/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets;

import com.swtxml.tinydom.Tag;
import java.io.File;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;

public class FileChooser
extends DVTWidget {
    private Button fBrowseButton;
    private Text fFileText;
    private Group fGroup = new Group((Composite)this, 0);
    private String fQuestion;
    private String fExtensions;

    public FileChooser(Composite parent, int style) {
        super(parent, style);
        this.fGroup.setLayout((Layout)new GridLayout(2, false));
        this.fGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fFileText = new Text((Composite)this.fGroup, 2048);
        this.fFileText.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fBrowseButton = new Button((Composite)this.fGroup, 8);
        this.fBrowseButton.setLayoutData((Object)new GridData(1, 128, false, false));
        this.fBrowseButton.setText("Browse...");
        this.fBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedFile;
                FileDialog fileDialog = new FileDialog(FileChooser.this.getShell());
                fileDialog.setText(FileChooser.this.fQuestion == null ? "" : FileChooser.this.fQuestion);
                File parentFile = new File(FileChooser.this.fFileText.getText()).getParentFile();
                if (parentFile != null && parentFile.exists()) {
                    fileDialog.setFilterPath(parentFile.getAbsolutePath());
                } else if (FileChooser.this.getProject() != null) {
                    fileDialog.setFilterPath(FileChooser.this.getProject().getLocation().toOSString());
                } else {
                    fileDialog.setFilterPath(null);
                }
                if (FileChooser.this.getExtensionsArray() != null) {
                    fileDialog.setFilterExtensions(FileChooser.this.getExtensionsArray());
                }
                if ((selectedFile = fileDialog.open()) != null) {
                    FileChooser.this.fFileText.setText(selectedFile);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    public String getValue() {
        return this.fFileText.getText();
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            return;
        }
        this.fFileText.setText(value);
    }

    @Override
    public void init(Tag tag) {
    }

    @Override
    public void setStringRepresentation(String value) {
        this.setValue(value);
    }

    @Override
    public String getStringRepresentation() {
        return this.getValue();
    }

    public void setQuestion(String question) {
        this.fQuestion = question;
        this.fGroup.setText(this.fQuestion);
    }

    public String getQuestion() {
        return this.fQuestion;
    }

    public void setExtensions(String extensions) {
        this.fExtensions = extensions;
    }

    public String getExtensions() {
        return this.fExtensions;
    }

    private String[] getExtensionsArray() {
        if (this.fExtensions == null) {
            return null;
        }
        return this.fExtensions.split(";");
    }
}

