/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets;

import com.swtxml.tinydom.Tag;
import com.swtxml.util.types.SimpleTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.customdialog.utils.FilteredList;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;

public class FilterListGroup
extends DVTWidget {
    private static final int DEFAULT_MIN_HEIGHT = 200;
    private static final int DEFAULT_MIN_WIDTH = 200;
    private Group fGroup;
    private Text fFilter;
    private FilteredList fFilteredList;
    private ILabelProvider fLabelProvider;
    private StringMatcher fMatcher;
    private FilteredList.FilterMatcher fFilterMatcher = new FilteredList.FilterMatcher(){

        @Override
        public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
            FilterListGroup.this.fMatcher = new StringMatcher(String.valueOf('*') + pattern + '*', ignoreCase, ignoreWildCards);
        }

        @Override
        public boolean match(Object element) {
            return FilterListGroup.this.fMatcher.match(FilterListGroup.this.fFilteredList.getLabelProvider().getText(element));
        }
    };
    private Object[] fLastSelection;
    private Object[] fElements;

    public FilterListGroup(Composite parent, int style) {
        this(parent, style, null);
    }

    public FilterListGroup(Composite parent, int style, ILabelProvider labelProvider) {
        super(parent, style);
        this.fGroup = new Group(parent, 0);
        this.fGroup.setLayout((Layout)new GridLayout());
        this.fGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fFilter = new Text((Composite)this.fGroup, 2048);
        DVTColorUtil.INSTANCE.setForeground((Control)this.fFilter, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.foregroundColor"), true);
        this.fFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterListGroup.this.fFilteredList.setFilter(FilterListGroup.this.fFilter.getText());
                if (FilterListGroup.this.fFilter.getText().length() == 0) {
                    DVTColorUtil.INSTANCE.setBackground((Control)FilterListGroup.this.fFilter, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
                } else {
                    DVTColorUtil.INSTANCE.setBackground((Control)FilterListGroup.this.fFilter, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"));
                }
            }
        });
        this.fFilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    FilterListGroup.this.fFilteredList.setFocus();
                }
            }
        });
        this.fFilter.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fLabelProvider = labelProvider == null ? new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                return null;
            }
        } : labelProvider;
        this.fFilteredList = new FilteredList((Composite)this.fGroup, 2050, this.fLabelProvider, true, false, true);
        this.fFilteredList.setComparator(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                if (o1.equals(o2)) {
                    return 0;
                }
                if (FilterListGroup.this.fLastSelection != null && Arrays.asList(FilterListGroup.this.fLastSelection).contains(o1)) {
                    return -1;
                }
                if (FilterListGroup.this.fLastSelection != null && Arrays.asList(FilterListGroup.this.fLastSelection).contains(o2)) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        this.fFilteredList.setFilterMatcher(this.fFilterMatcher);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 200;
        gridData.minimumWidth = 200;
        this.fFilteredList.setLayoutData(gridData);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fFilteredList.addSelectionListener(listener);
    }

    public void setComparator(Comparator<?> comparator) {
        this.fFilteredList.setComparator(comparator);
    }

    public Object[] getListSelection() {
        return this.fFilteredList.getSelection();
    }

    @Override
    public void init(Tag tag) {
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void setValue(String value) {
    }

    @Override
    public String getStringRepresentation() {
        if (this.fFilteredList.getSelection() == null) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = this.fFilteredList.getSelection();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            result.add(o.toString());
            ++n2;
        }
        return DVTStringUtil.join(result, (String)";");
    }

    @Override
    public void setStringRepresentation(String value) {
        if (this.fElements == null) {
            return;
        }
        if (value != null) {
            this.fLastSelection = (Object[])SimpleTypes.STRING_ARRAY.convert(value);
        }
        this.fFilteredList.setElements(this.fElements);
        if (this.fLastSelection != null) {
            this.fFilteredList.setSelection(this.fLastSelection);
        }
    }

    public void setSelection(Object[] elements) {
        this.fFilteredList.setSelection(elements);
    }

    public Object[] getSelection() {
        return this.fFilteredList.getSelection();
    }

    public void setListElements(Object[] elements) {
        this.fElements = elements;
        this.fFilteredList.setElements(elements);
    }

    public Object[] getListElements() {
        return this.fElements;
    }

    public boolean isEmpty() {
        return this.fFilteredList.isEmpty();
    }

    public void setText(String string) {
        this.fGroup.setText(string);
    }

    public void setMinHeight(int minHeight) {
        if (this.fFilteredList == null) {
            return;
        }
        Object lData = this.fFilteredList.getLayoutData();
        if (!(lData instanceof GridData)) {
            return;
        }
        ((GridData)lData).minimumHeight = minHeight;
    }

    public void setMinimumWidth(int minWidth) {
        if (this.fFilteredList == null) {
            return;
        }
        Object lData = this.fFilteredList.getLayoutData();
        if (!(lData instanceof GridData)) {
            return;
        }
        ((GridData)lData).minimumWidth = minWidth;
    }

    public int getMinHeight() {
        if (this.fFilteredList == null) {
            return 200;
        }
        Object lData = this.fFilteredList.getLayoutData();
        if (!(lData instanceof GridData)) {
            return 200;
        }
        return ((GridData)lData).minimumHeight;
    }

    public int getMinWidth() {
        if (this.fFilteredList == null) {
            return 200;
        }
        Object lData = this.fFilteredList.getLayoutData();
        if (!(lData instanceof GridData)) {
            return 200;
        }
        return ((GridData)lData).minimumWidth;
    }
}

