/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets.e;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.customdialog.widgets.BaseSelector;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.THViewLabelProvider;
import ro.amiq.edt.core.EPluginConfig;
import ro.amiq.edt.model.reflection.RfManager;

public class StructSelector
extends BaseSelector {
    private int fHierarchyLevel;
    private String fBaseStructName;
    private String fHierarchyLevelString;
    private boolean fShowWhenSubtypes = false;

    public StructSelector(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected Object[] getDefaultElements() {
        return new RfTreeElementWrapper[]{new RfTreeElementWrapper((Object)"Struct_A"), new RfTreeElementWrapper((Object)"Struct_B"), new RfTreeElementWrapper((Object)"Struct_C")};
    }

    @Override
    protected ILabelProvider getLabelProvider() {
        return new THViewLabelProvider((IEPluginConfig)EPluginConfig.getInstance());
    }

    @Override
    protected Object[] computeElements() {
        this.setComparator(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String string1 = (String)o1;
                    String string2 = (String)o2;
                    int whitespaceIndex1 = string1.lastIndexOf(" ");
                    int whitespaceIndex2 = string2.lastIndexOf(" ");
                    String comparisonString1 = "";
                    String comparisonString2 = "";
                    if ((comparisonString1 = String.valueOf(comparisonString1) + string1.substring(whitespaceIndex1 + 1)).equals(comparisonString2 = String.valueOf(comparisonString2) + string2.substring(whitespaceIndex2 + 1))) {
                        if (whitespaceIndex1 != -1 && whitespaceIndex2 != -1) {
                            return string1.compareTo(string2);
                        }
                        if (whitespaceIndex1 == -1 && whitespaceIndex2 != -1) {
                            return -1;
                        }
                        if (whitespaceIndex1 != -1 && whitespaceIndex2 == -1) {
                            return 1;
                        }
                        return 0;
                    }
                    return comparisonString1.compareTo(comparisonString2);
                }
                return 0;
            }
        });
        IProject project = this.getProject();
        if (project == null) {
            return this.makeMessageElements("Unable to infer project from current selection");
        }
        if (!DVTNature.hasNature((IProject)project, (String)"ro.amiq.edt.enature")) {
            return this.makeMessageElements("Project '" + project.getName() + "' does not have the e Language nature!");
        }
        RfProject eProject = RfManager.getInstance().getRfProject(project);
        if (eProject == null) {
            return this.makeMessageElements("Project '" + project.getName() + "' is not properly configured!");
        }
        HashSet<AbstractRfTreeElementWrapper> elements = null;
        if (this.fBaseStructName != null) {
            List structs;
            if (this.fHierarchyLevelString == null) {
                this.fHierarchyLevel = Integer.MAX_VALUE;
            }
            if ((structs = eProject.getStructsWithPrefix(1, this.fBaseStructName)) == null || structs.isEmpty()) {
                return this.makeMessageElements("No struct called " + this.getBaseStructName() + " in project '" + project.getName() + "'");
            }
            RfStruct struct = (RfStruct)structs.get(0);
            elements = new HashSet();
            this.getRecursiveStructChildren(elements, struct);
        } else {
            List structs = eProject.getAllStructs();
            elements = new HashSet<AbstractRfTreeElementWrapper>();
            for (RfStruct struct : structs) {
                elements.add((AbstractRfTreeElementWrapper)new RfTreeElementWrapper((Object)struct));
            }
        }
        if (elements.isEmpty()) {
            return this.makeMessageElements("No children for struct called " + this.getBaseStructName() + " in project '" + project.getName() + "'");
        }
        return elements.toArray();
    }

    private int getRecursiveStructChildren(Set<AbstractRfTreeElementWrapper> result, RfStruct struct) {
        List children = struct.getChildStructs();
        if (children == null || children.isEmpty()) {
            if (this.fShowWhenSubtypes) {
                List layers = struct.getSubTypeLayers();
                for (RfStructLayer layer : layers) {
                    RfTreeElementWrapper subtypeWrapper = new RfTreeElementWrapper((Object)layer);
                    result.add((AbstractRfTreeElementWrapper)subtypeWrapper);
                }
            }
            if (this.fHierarchyLevel > 0) {
                result.add((AbstractRfTreeElementWrapper)new RfTreeElementWrapper((Object)struct));
            }
            return 0;
        }
        int level = this.fHierarchyLevel + 1;
        for (RfStruct child : children) {
            int childLevel = this.getRecursiveStructChildren(result, child);
            if (childLevel >= level) continue;
            level = childLevel;
        }
        if (++level < this.fHierarchyLevel) {
            result.add((AbstractRfTreeElementWrapper)new RfTreeElementWrapper((Object)struct));
        }
        return level;
    }

    private AbstractRfTreeElementWrapper[] makeMessageElements(String text) {
        return new AbstractRfTreeElementWrapper[]{new RfTreeElementWrapper((Object)text)};
    }

    public void setBaseStructName(String value) {
        this.fBaseStructName = value;
    }

    public String getBaseStructName() {
        return this.fBaseStructName;
    }

    public void setHierarchyLevels(String hierarchyLevel) {
        this.fHierarchyLevelString = hierarchyLevel;
        this.fHierarchyLevel = Integer.MAX_VALUE;
        try {
            this.fHierarchyLevel = Integer.parseInt(this.fHierarchyLevelString);
        }
        catch (Exception exception) {}
    }

    public String getHierarchyLevels() {
        return this.fHierarchyLevelString;
    }

    public void setShowWhenSubtypes(boolean showWhenSubtypes) {
        this.fShowWhenSubtypes = showWhenSubtypes;
    }

    public boolean getShowWhenSubtypes() {
        return this.fShowWhenSubtypes;
    }
}

