/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets.e;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.customdialog.widgets.BaseSelector;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.model.EModelManager;

public class TestSelector
extends BaseSelector {
    public TestSelector(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected Object[] getDefaultElements() {
        return new String[]{"Test 1", "Test 2", "Test 3"};
    }

    @Override
    protected ILabelProvider getLabelProvider() {
        return new ListLabelProvider();
    }

    @Override
    protected Object[] computeElements() {
        IProject project = this.getProject();
        if (project == null) {
            return this.makeMessageElements("Unable to infer project from current selection");
        }
        if (!DVTNature.hasNature((IProject)project, (String)"ro.amiq.edt.enature")) {
            return this.makeMessageElements("Project '" + project.getName() + "' does not have the e Language nature!");
        }
        IEProject eProject = EModelManager.getInstance().getEModel().getEProject(project);
        if (eProject == null) {
            return this.makeMessageElements("Project '" + project.getName() + "' is not properly configured!");
        }
        CompilationUnitProperties compilationUnitProperties = eProject.getCompilationUnitProperties(false);
        List testFiles = compilationUnitProperties.testFiles();
        if (testFiles == null || testFiles.isEmpty()) {
            return this.makeMessageElements("Project '" + project.getName() + "' does not have any e Langauge test files specified!");
        }
        ArrayList<ListElement> elements = new ArrayList<ListElement>();
        for (ParserPath testFile : testFiles) {
            elements.add(new ListElement(testFile));
        }
        return elements.toArray(new ListElement[elements.size()]);
    }

    private ListElement[] makeMessageElements(String text) {
        return new ListElement[]{new DummyListElement(text)};
    }

    private static class DummyListElement
    extends ListElement {
        private String fText;

        public DummyListElement(String text) {
            super(null);
            this.fText = text;
        }

        public String getText() {
            return this.fText;
        }
    }

    private static class ListElement {
        private final ParserPath fParserPath;

        public ListElement(ParserPath parserPath) {
            this.fParserPath = parserPath;
        }
    }

    private static class ListLabelProvider
    extends LabelProvider {
        private ListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof DummyListElement) {
                return ((DummyListElement)element).getText();
            }
            if (element instanceof ListElement) {
                String path = ((ListElement)element).fParserPath.path;
                return Path.fromOSString((String)path).removeFileExtension().lastSegment();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE);
        }
    }
}

