/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets.sv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.customdialog.widgets.BaseSelector;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.TypesViewLabelProvider;

public class ClassSelector
extends BaseSelector {
    private String fBaseClassName;
    private boolean fExcludeVirtual;
    private boolean fShowDefaultParams;

    public ClassSelector(Composite parent, int style) {
        super(parent, style);
    }

    protected RfTreeElementWrapper[] getDefaultElements() {
        return new RfTreeElementWrapper[]{new RfTreeElementWrapper((Object)"Class_A"), new RfTreeElementWrapper((Object)"Class_B"), new RfTreeElementWrapper((Object)"Class_C")};
    }

    protected TypesViewLabelProvider getLabelProvider() {
        if (this.getShowDefaultParams()) {
            return new TypesViewLabelProvider();
        }
        return new NoParamsViewLabelProvider();
    }

    @Override
    protected Object[] computeElements() {
        IProject project = this.getProject();
        if (project == null) {
            return this.makeMessageElements("Unable to infer project from current selection");
        }
        if (!DVTNature.hasNature((IProject)project, (String)"ro.amiq.vlogdt.VlogNature")) {
            return this.makeMessageElements("Project '" + project.getName() + "' does not have the Verilog nature!");
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return this.makeMessageElements("Project '" + project.getName() + "' is not properly configured!");
        }
        List<RfClass> elements = null;
        if (this.fBaseClassName != null) {
            RfClass baseClass = rfProject.getClass(this.fBaseClassName, false);
            if (baseClass == null || !(baseClass instanceof RfClass)) {
                return this.makeMessageElements("No class called " + this.getBaseClassName() + " in project '" + project.getName() + "'");
            }
            elements = new ArrayList<RfClass>();
            this.getRecursiveClassChildren(elements, baseClass);
        } else {
            RfClass[] classes = rfProject.getAllClasses();
            elements = Arrays.asList(classes);
        }
        ArrayList<RfTreeElementWrapper> wrappers = new ArrayList<RfTreeElementWrapper>();
        if (elements.isEmpty()) {
            return this.makeMessageElements("No children for class called " + this.getBaseClassName() + " in project '" + project.getName() + "'");
        }
        for (RfNamedElement rfNamedElement : elements) {
            wrappers.add(new RfTreeElementWrapper((Object)rfNamedElement));
        }
        return wrappers.toArray();
    }

    private void getRecursiveClassChildren(List<RfNamedElement> result, RfClass clazz) {
        Set children = clazz.getChildren();
        if (children == null) {
            return;
        }
        for (RfClass child : children) {
            if (this.fExcludeVirtual && child.isVirtual()) continue;
            result.add((RfNamedElement)child);
        }
        for (RfClass child : children) {
            this.getRecursiveClassChildren(result, child);
        }
    }

    private RfTreeElementWrapper[] makeMessageElements(String text) {
        return new RfTreeElementWrapper[]{new RfTreeElementWrapper((Object)text)};
    }

    public void setBaseClassName(String value) {
        this.fBaseClassName = value;
    }

    public String getBaseClassName() {
        return this.fBaseClassName;
    }

    public void setExcludeVirtual(boolean excludeVirtual) {
        this.fExcludeVirtual = excludeVirtual;
    }

    public boolean getExcludeVirtual() {
        return this.fExcludeVirtual;
    }

    public void setShowDefaultParams(boolean showDefaultParams) {
        this.fShowDefaultParams = showDefaultParams;
    }

    public boolean getShowDefaultParams() {
        return this.fShowDefaultParams;
    }

    static class NoParamsViewLabelProvider
    extends TypesViewLabelProvider {
        NoParamsViewLabelProvider() {
        }

        public String getText(Object object) {
            String text = super.getText(object);
            int index = text.indexOf(35);
            return index < 0 ? text : text.substring(0, index);
        }
    }
}

