/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme;

import org.eclipse.swt.graphics.RGB;

public class Color {
    public static final float DARKNESS_THRESHOLD = 0.5f;
    private Integer r = 0;
    private Integer g = 0;
    private Integer b = 0;
    private float[] hsb;

    public Color(String value) {
        if (value != null && value.startsWith("#")) {
            this.r = Integer.parseInt(value.substring(1, 3), 16);
            this.g = Integer.parseInt(value.substring(3, 5), 16);
            this.b = Integer.parseInt(value.substring(5, 7), 16);
            this.hsb = new RGB(this.r.intValue(), this.g.intValue(), this.b.intValue()).getHSB();
        }
    }

    public Color(Color copy) {
        this.r = copy.r;
        this.g = copy.g;
        this.b = copy.b;
        this.hsb = new RGB(this.r.intValue(), this.g.intValue(), this.b.intValue()).getHSB();
    }

    public Integer getR() {
        return this.r;
    }

    public Integer getG() {
        return this.g;
    }

    public Integer getB() {
        return this.b;
    }

    public String asHex() {
        String hexr = Integer.toHexString(this.r).toUpperCase();
        String hexg = Integer.toHexString(this.g).toUpperCase();
        String hexb = Integer.toHexString(this.b).toUpperCase();
        return "#" + (hexr.length() == 2 ? hexr : "0" + hexr) + (hexg.length() == 2 ? hexg : "0" + hexg) + (hexb.length() == 2 ? hexb : "0" + hexb);
    }

    public String asRGB() {
        return this.r + "," + this.g + "," + this.b;
    }

    public void adjustHSB(float h, float s, float b) {
        java.awt.Color newColor = java.awt.Color.getHSBColor(this.hsb[0] + h, this.hsb[1] + s, this.hsb[2] + b);
        this.r = newColor.getRed();
        this.g = newColor.getGreen();
        this.b = newColor.getBlue();
    }

    public boolean isDarkColor() {
        return this.hsb[2] < 0.5f;
    }

    public String toString() {
        return this.r + "," + this.g + "," + this.b;
    }
}

