/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme;

import com.github.eclipsecolortheme.Activator;
import com.github.eclipsecolortheme.Color;
import com.github.eclipsecolortheme.ColorTheme;
import com.github.eclipsecolortheme.ColorThemeMapping;
import com.github.eclipsecolortheme.ColorThemeSetting;
import com.github.eclipsecolortheme.ParsedTheme;
import com.github.eclipsecolortheme.mapper.GenericMapper;
import com.github.eclipsecolortheme.mapper.ThemePreferenceMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ColorThemeManager {
    private Map<String, ColorTheme> themes;
    private Map<String, ThemePreferenceMapper> editors = new HashMap<String, ThemePreferenceMapper>();

    public ColorThemeManager() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.github.eclipsecolortheme.mapper");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    ThemePreferenceMapper mapper;
                    String pluginId;
                    block6: {
                        IConfigurationElement e = iConfigurationElementArray[n2];
                        Object o = e.createExecutableExtension("class");
                        if (!(o instanceof ThemePreferenceMapper) || (pluginId = e.getAttribute("pluginId")) == null) break block5;
                        mapper = (ThemePreferenceMapper)o;
                        mapper.setPluginId(pluginId);
                        if (!(o instanceof GenericMapper)) break block6;
                        String xml = e.getAttribute("xml");
                        if (xml == null) break block5;
                        String contributorPluginId = e.getContributor().getName();
                        Bundle bundle = Platform.getBundle((String)contributorPluginId);
                        InputStream input = (InputStream)bundle.getResource(xml).getContent();
                        ((GenericMapper)mapper).parseMappings(input);
                        input.close();
                    }
                    this.editors.put(pluginId, mapper);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Activator.logError(e);
        }
        this.themes = new HashMap<String, ColorTheme>();
        this.readStockThemes(this.themes);
        this.readImportedThemes(this.themes);
    }

    private void readStockThemes(Map<String, ColorTheme> themes) {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.github.eclipsecolortheme.theme");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String xml = e.getAttribute("file");
                if (xml != null) {
                    String contributorPluginId = e.getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)contributorPluginId);
                    InputStream input = (InputStream)bundle.getResource(xml).getContent();
                    ParsedTheme theme = this.parseTheme(input, false);
                    ColorThemeManager.amendThemeEntries(theme.getTheme().getEntries());
                    themes.put(theme.getTheme().getName(), theme.getTheme());
                    input.close();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Activator.logError(e);
        }
    }

    private void readImportedThemes(Map<String, ColorTheme> themes) {
        String xml;
        IPreferenceStore store = ColorThemeManager.getPreferenceStore();
        int i = 1;
        while ((xml = store.getString("importedColorTheme" + i)) != null && xml.length() != 0) {
            try {
                ParsedTheme theme = this.parseTheme(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)), false);
                ColorThemeManager.amendThemeEntries(theme.getTheme().getEntries());
                themes.put(theme.getTheme().getName(), theme.getTheme());
            }
            catch (Exception e) {
                Activator.logError("Error while parsing imported theme", e);
            }
            ++i;
        }
    }

    public void clearImportedThemes() {
        IPreferenceStore store = ColorThemeManager.getPreferenceStore();
        int i = 1;
        while (store.contains("importedColorTheme" + i)) {
            store.setToDefault("importedColorTheme" + i);
            ++i;
        }
        this.themes.clear();
        this.readStockThemes(this.themes);
    }

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public ParsedTheme parseTheme(InputStream input, boolean loadSource) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        ColorTheme theme = new ColorTheme();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        Element root = document.getDocumentElement();
        theme.setId(root.getAttribute("id"));
        theme.setName(root.getAttribute("name"));
        HashMap<String, ColorThemeSetting> entries = new HashMap<String, ColorThemeSetting>();
        NodeList entryNodes = root.getChildNodes();
        int i = 0;
        while (i < entryNodes.getLength()) {
            NamedNodeMap attributes;
            Node nodeColor;
            Node entryNode = entryNodes.item(i);
            if (entryNode.hasAttributes() && (nodeColor = (attributes = entryNode.getAttributes()).getNamedItem("color")) != null) {
                Node nodeBold = attributes.getNamedItem("bold");
                Node nodeItalic = attributes.getNamedItem("italic");
                Node nodeUnderline = attributes.getNamedItem("underline");
                Node nodeStrikethrough = attributes.getNamedItem("strikethrough");
                ColorThemeSetting setting = new ColorThemeSetting(nodeColor.getNodeValue());
                if (nodeBold != null) {
                    setting.setBoldEnabled(Boolean.parseBoolean(nodeBold.getNodeValue()));
                }
                if (nodeItalic != null) {
                    setting.setItalicEnabled(Boolean.parseBoolean(nodeItalic.getNodeValue()));
                }
                if (nodeStrikethrough != null) {
                    setting.setStrikethroughEnabled(Boolean.parseBoolean(nodeStrikethrough.getNodeValue()));
                }
                if (nodeUnderline != null) {
                    setting.setUnderlineEnabled(Boolean.parseBoolean(nodeUnderline.getNodeValue()));
                }
                entries.put(entryNode.getNodeName(), setting);
            }
            ++i;
        }
        theme.setEntries(entries);
        NodeList nodeListMappingOverrides = root.getElementsByTagName("mappingOverrides");
        if (nodeListMappingOverrides.getLength() > 0) {
            Element mappingOverridesRoot = (Element)nodeListMappingOverrides.item(0);
            HashMap<String, Map<String, ColorThemeMapping>> mappings = new HashMap<String, Map<String, ColorThemeMapping>>();
            NodeList nodeListEclipseColorThemeMapping = mappingOverridesRoot.getChildNodes();
            int i2 = 0;
            while (i2 < nodeListEclipseColorThemeMapping.getLength()) {
                Node nodePlugin;
                Node eclipseColorThemeMapping = nodeListEclipseColorThemeMapping.item(i2);
                if (eclipseColorThemeMapping.hasAttributes() && (nodePlugin = eclipseColorThemeMapping.getAttributes().getNamedItem("plugin")) != null) {
                    String pluginId = nodePlugin.getNodeValue();
                    HashMap<String, ColorThemeMapping> mapMappings = new HashMap<String, ColorThemeMapping>();
                    ThemePreferenceMapper mapper = this.editors.get(pluginId);
                    if (mapper instanceof GenericMapper) {
                        ((GenericMapper)mapper).parseMappings((Element)eclipseColorThemeMapping, mapMappings);
                        mappings.put(pluginId, mapMappings);
                    }
                }
                ++i2;
            }
            theme.setMappings(mappings);
        }
        ParsedTheme parsedTheme = new ParsedTheme(theme);
        if (loadSource) {
            parsedTheme.setSource(ColorThemeManager.documentToString(document));
        }
        return parsedTheme;
    }

    private static void amendThemeEntries(Map<String, ColorThemeSetting> theme) {
        ColorThemeManager.applyDefault(theme, "method", "foreground");
        ColorThemeManager.applyDefault(theme, "field", "foreground");
        ColorThemeManager.applyDefault(theme, "localVariable", "foreground");
        ColorThemeManager.applyDefault(theme, "javadoc", "multiLineComment");
        ColorThemeManager.applyDefault(theme, "javadocLink", "javadoc");
        ColorThemeManager.applyDefault(theme, "javadocTag", "javadoc");
        ColorThemeManager.applyDefault(theme, "javadocKeyword", "javadoc");
        ColorThemeManager.applyDefault(theme, "occurrenceIndication", "background");
        ColorThemeManager.applyDefault(theme, "writeOccurrenceIndication", "occurrenceIndication");
        ColorThemeManager.applyDefault(theme, "debugCurrentInstructionPointer", "currentLine");
        ColorThemeManager.applyDefault(theme, "debugSecondaryInstructionPointer", "currentLine");
    }

    private static void applyDefault(Map<String, ColorThemeSetting> theme, String key, String defaultKey) {
        if (!theme.containsKey(key)) {
            theme.put(key, theme.get(defaultKey));
        }
    }

    public Set<ColorTheme> getThemes() {
        return new HashSet<ColorTheme>(this.themes.values());
    }

    public ColorTheme getTheme(String name) {
        return this.themes.get(name);
    }

    public void applyTheme(String themeName) {
        ColorTheme theme = this.themes.get(themeName);
        for (ThemePreferenceMapper editor : this.editors.values()) {
            editor.clear();
            if (theme != null) {
                editor.map(theme.getEntries(), theme.getMappings() == null ? null : theme.getMappings().get(editor.getPluginId()));
            }
            try {
                editor.flush();
            }
            catch (BackingStoreException e) {
                Activator.logError(e);
            }
        }
    }

    public Color getThemeBackground(String themeName) {
        ColorTheme theme = this.themes.get(themeName);
        if (theme == null) {
            return null;
        }
        return theme.getEntries().get("background").getColor();
    }

    public ThemePreferenceMapper getEditorMapper(String pluginID) {
        return this.editors.get(pluginID);
    }

    public void saveTheme(InputStream input) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        ParsedTheme theme = this.parseTheme(input, true);
        this.themes.put(theme.getTheme().getName(), theme.getTheme());
        IPreferenceStore store = ColorThemeManager.getPreferenceStore();
        int i = 1;
        while (true) {
            if (!store.contains("importedColorTheme" + i)) break;
            ++i;
        }
        store.putValue("importedColorTheme" + i, theme.getSource());
    }

    protected static String documentToString(Document document) throws TransformerException {
        StringWriter writer = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }
}

