/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme.mapper;

import com.github.eclipsecolortheme.Color;
import com.github.eclipsecolortheme.ColorThemeSetting;
import com.github.eclipsecolortheme.mapper.GenericMapper;
import java.util.HashMap;
import java.util.Map;

public class DVTEditorMapper
extends GenericMapper {
    private static final Map<String, Float> BRIGHTNESS_ADJUSTMENT = new HashMap<String, Float>();

    static {
        BRIGHTNESS_ADJUSTMENT.put("inactiveCodeHighlightColor", Float.valueOf(0.1f));
        BRIGHTNESS_ADJUSTMENT.put("inspect.context_color", Float.valueOf(0.1f));
        BRIGHTNESS_ADJUSTMENT.put("inactiveGenerateBranchHighlightColor", Float.valueOf(0.1f));
        BRIGHTNESS_ADJUSTMENT.put("protectedCodeHighlightColor", Float.valueOf(0.2f));
        BRIGHTNESS_ADJUSTMENT.put("inspect.file_info_color", Float.valueOf(0.2f));
    }

    @Override
    public boolean customizePreferenceMapping(String pluginKey, Map<String, ColorThemeSetting> theme) {
        Float brightness = BRIGHTNESS_ADJUSTMENT.get(pluginKey);
        if (brightness == null) {
            return false;
        }
        Color backgroundColor = theme.get("background").getColor();
        this.darknessDependentBrightnessAdjustment(pluginKey, backgroundColor, brightness.floatValue());
        return true;
    }

    private void darknessDependentBrightnessAdjustment(String pluginKey, Color baseColor, float b) {
        Color newColor = new Color(baseColor);
        if (newColor.isDarkColor()) {
            newColor.adjustHSB(0.0f, 0.0f, b);
        } else {
            newColor.adjustHSB(0.0f, 0.0f, -b);
        }
        this.preferences.put(pluginKey, newColor.asRGB());
    }
}

