/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme.mapper;

import com.github.eclipsecolortheme.ColorThemeMapping;
import com.github.eclipsecolortheme.ColorThemeSemanticHighlightingMapping;
import com.github.eclipsecolortheme.ColorThemeSetting;
import com.github.eclipsecolortheme.mapper.ThemePreferenceMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenericMapper
extends ThemePreferenceMapper {
    private Map<String, ColorThemeMapping> mappings = new HashMap<String, ColorThemeMapping>();
    protected ColorThemeSetting defaultBackground;

    public void parseMappings(InputStream input) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        this.parseMappings(document.getDocumentElement());
    }

    public void parseMappings(Element root) throws SAXException, IOException, ParserConfigurationException {
        this.parseMappings(root, this.mappings);
    }

    public void parseMappings(Element root, Map<String, ColorThemeMapping> mappings) throws SAXException, IOException, ParserConfigurationException {
        this.parseStandardMappings(root, mappings);
        this.parseSemanticHighlightingMappings(root, mappings);
    }

    private void parseStandardMappings(Element root, Map<String, ColorThemeMapping> mappings) {
        Node mappingsNode = root.getElementsByTagName("mappings").item(0);
        if (mappingsNode == null) {
            return;
        }
        NodeList mappingNodes = mappingsNode.getChildNodes();
        int i = 0;
        while (i < mappingNodes.getLength()) {
            Node mappingNode = mappingNodes.item(i);
            if (mappingNode.hasAttributes()) {
                String pluginKey = GenericMapper.extractAttribute(mappingNode, "pluginKey");
                String themeKey = GenericMapper.extractAttribute(mappingNode, "themeKey");
                if (pluginKey != null && themeKey != null) {
                    mappings.put(pluginKey, this.createMapping(pluginKey, themeKey));
                }
            }
            ++i;
        }
    }

    private void parseSemanticHighlightingMappings(Element root, Map<String, ColorThemeMapping> mappings) {
        Node mappingsNode = root.getElementsByTagName("semanticHighlightingMappings").item(0);
        if (mappingsNode == null) {
            return;
        }
        NodeList mappingNodes = mappingsNode.getChildNodes();
        int i = 0;
        while (i < mappingNodes.getLength()) {
            Node mappingNode = mappingNodes.item(i);
            if (mappingNode.hasAttributes()) {
                String pluginKey = GenericMapper.extractAttribute(mappingNode, "pluginKey");
                String themeKey = GenericMapper.extractAttribute(mappingNode, "themeKey");
                if (pluginKey != null && themeKey != null) {
                    mappings.put(pluginKey, this.createSemanticHighlightingMapping(pluginKey, themeKey));
                }
            }
            ++i;
        }
    }

    protected ColorThemeMapping createMapping(String pluginKey, String themeKey) {
        return new ColorThemeMapping(pluginKey, themeKey);
    }

    protected ColorThemeSemanticHighlightingMapping createSemanticHighlightingMapping(String pluginKey, String themeKey) {
        return new ColorThemeSemanticHighlightingMapping(pluginKey, themeKey);
    }

    private static String extractAttribute(Node node, String name) {
        Node nodeAttribute = node.getAttributes().getNamedItem(name);
        if (nodeAttribute == null) {
            return null;
        }
        return nodeAttribute.getNodeValue();
    }

    @Override
    public void map(Map<String, ColorThemeSetting> theme, Map<String, ColorThemeMapping> overrideMappings) {
        this.defaultBackground = theme.get("background");
        for (Map.Entry<String, ColorThemeMapping> entry : this.mappings.entrySet()) {
            String pluginKey = entry.getKey();
            ColorThemeMapping overrideMapping = overrideMappings != null ? overrideMappings.get(pluginKey) : null;
            ColorThemeMapping mapping = overrideMapping != null ? overrideMapping : entry.getValue();
            ColorThemeSetting setting = theme.get(mapping.getThemeKey());
            if (this.customizePreferenceMapping(pluginKey, theme) || setting == null) continue;
            mapping.putPreferences(this.preferences, setting);
        }
    }

    public void previewMap(Map<String, ColorThemeSetting> theme, Map<String, ColorThemeMapping> overrideMappings, IPreferenceStore previewPreferenceStore) {
        for (Map.Entry<String, ColorThemeMapping> entry : this.mappings.entrySet()) {
            ColorThemeSetting setting;
            String pluginKey = entry.getKey();
            ColorThemeMapping overrideMapping = overrideMappings != null ? overrideMappings.get(pluginKey) : null;
            ColorThemeMapping mapping = overrideMapping != null ? overrideMapping : entry.getValue();
            ColorThemeSetting colorThemeSetting = setting = theme != null ? theme.get(mapping.getThemeKey()) : null;
            if (setting == null) continue;
            previewPreferenceStore.setValue(pluginKey, setting.getColor().toString());
        }
    }

    public void defaultPreviewMap(IPreferenceStore previewPreferenceStore, IPreferenceStore defaultPreferenceStore) {
        for (String pluginKey : this.mappings.keySet()) {
            previewPreferenceStore.setValue(pluginKey, defaultPreferenceStore.getDefaultString(pluginKey));
        }
    }

    public void copyMapping(IPreferenceStore previewPreferenceStore, Map<String, String> initialKeyValues) {
        for (String pluginKey : this.mappings.keySet()) {
            initialKeyValues.put(pluginKey, previewPreferenceStore.getString(pluginKey));
        }
    }

    public void restoreDefaultValues(IPreferenceStore previewPreferenceStore, Map<String, String> defaultValues) {
        for (String pluginKey : this.mappings.keySet()) {
            previewPreferenceStore.setValue(pluginKey, defaultValues.get(pluginKey));
        }
    }

    @Override
    public void clear() {
        for (ColorThemeMapping mapping : this.mappings.values()) {
            mapping.removePreferences(this.preferences);
        }
    }

    public boolean customizePreferenceMapping(String pluginKey, Map<String, ColorThemeSetting> theme) {
        return false;
    }
}

