/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme.mapper;

import com.github.eclipsecolortheme.ColorThemeMapping;
import com.github.eclipsecolortheme.ColorThemeSetting;
import com.github.eclipsecolortheme.mapper.GenericMapper;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class JsonToolsEditorMapper
extends GenericMapper {
    @Override
    protected ColorThemeMapping createMapping(String pluginKey, String themeKey) {
        return new Mapping(pluginKey, themeKey);
    }

    private static class Mapping
    extends ColorThemeMapping {
        private static final int STYLE_VALUE_UNDERLINE = 0x40000000;
        private static final int STYLE_VALUE_STRIKETHROUGH = 0x20000000;

        public Mapping(String pluginKey, String themeKey) {
            super(pluginKey, themeKey);
        }

        @Override
        public void putPreferences(IEclipsePreferences preferences, ColorThemeSetting setting) {
            super.putPreferences(preferences, setting);
            preferences.putBoolean(String.valueOf(this.pluginKey) + "Enabled", true);
            preferences.putInt(String.valueOf(this.pluginKey) + "Style", this.getStyleValue(setting));
        }

        private int getStyleValue(ColorThemeSetting setting) {
            boolean bold = Boolean.TRUE.equals(setting.isBoldEnabled());
            boolean italic = Boolean.TRUE.equals(setting.isItalicEnabled());
            boolean underline = Boolean.TRUE.equals(setting.isUnderlineEnabled());
            boolean strikethrough = Boolean.TRUE.equals(setting.isStrikethroughEnabled());
            int style = 0;
            style |= bold ? 1 : 0;
            style |= italic ? 2 : 0;
            style |= underline ? 0x40000000 : 0;
            return style |= strikethrough ? 0x20000000 : 0;
        }
    }
}

