/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme.mapper;

import com.github.eclipsecolortheme.ColorThemeMapping;
import com.github.eclipsecolortheme.ColorThemeSetting;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ThemePreferenceMapper {
    protected IEclipsePreferences preferences;

    public ThemePreferenceMapper() {
    }

    public ThemePreferenceMapper(String plugin) {
        this.setPluginId(plugin);
    }

    public void setPluginId(String plugin) {
        this.preferences = new InstanceScope().getNode(plugin);
    }

    public String getPluginId() {
        return this.preferences.name();
    }

    public void flush() throws BackingStoreException {
        this.preferences.flush();
    }

    public abstract void map(Map<String, ColorThemeSetting> var1, Map<String, ColorThemeMapping> var2);

    public abstract void clear();

    protected String hexToRGB(String hexColor) {
        String hexR = hexColor.substring(1, 3);
        String hexG = hexColor.substring(3, 5);
        String hexB = hexColor.substring(5, 7);
        return String.valueOf(this.hexToDec(hexR)) + ", " + this.hexToDec(hexG) + ", " + this.hexToDec(hexB);
    }

    private String hexToDec(String hex) {
        return String.valueOf(Integer.parseInt(hex, 16));
    }
}

