/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme.mapper;

import com.github.eclipsecolortheme.ColorThemeMapping;
import com.github.eclipsecolortheme.ColorThemeSemanticHighlightingMapping;
import com.github.eclipsecolortheme.ColorThemeSetting;
import com.github.eclipsecolortheme.mapper.GenericMapper;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class WebEditorMapper
extends GenericMapper {
    @Override
    protected ColorThemeMapping createMapping(String pluginKey, String themeKey) {
        return new Mapping(pluginKey, themeKey);
    }

    @Override
    protected ColorThemeSemanticHighlightingMapping createSemanticHighlightingMapping(String pluginKey, String themeKey) {
        return new SemanticMapping(pluginKey, themeKey);
    }

    private class Mapping
    extends ColorThemeMapping {
        public Mapping(String pluginKey, String themeKey) {
            super(pluginKey, themeKey);
        }

        @Override
        public void putPreferences(IEclipsePreferences preferences, ColorThemeSetting setting) {
            String value = String.valueOf(setting.getColor().asHex()) + " | " + WebEditorMapper.this.defaultBackground.getHexColorOrNull() + " | " + setting.isBoldEnabled() + " | " + setting.isItalicEnabled() + " | " + setting.isStrikethroughEnabled() + " | " + setting.isUnderlineEnabled();
            preferences.put(this.pluginKey, value);
        }
    }

    private static class SemanticMapping
    extends ColorThemeSemanticHighlightingMapping {
        public SemanticMapping(String pluginKey, String themeKey) {
            super(pluginKey, themeKey);
        }

        @Override
        public void putPreferences(IEclipsePreferences preferences, ColorThemeSetting setting) {
            super.putPreferences(preferences, setting);
            preferences.put(String.valueOf(this.pluginKey) + this.separator + "color", setting.getColor().asHex());
        }
    }
}

