/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme.mapper;

import com.github.eclipsecolortheme.Color;
import com.github.eclipsecolortheme.ColorThemeSetting;
import com.github.eclipsecolortheme.mapper.GenericMapper;
import java.util.Map;
import org.eclipse.core.runtime.Platform;

public class WorkbenchMapper
extends GenericMapper {
    private static final String ORG_ECLIPSE_UI_WORKBECNH_ID = "org.eclipse.ui.workbench";
    protected static final boolean IS_LINUX = "linux".equals(Platform.getOS());

    @Override
    public boolean customizePreferenceMapping(String pluginKey, Map<String, ColorThemeSetting> theme) {
        if (pluginKey.equals("org.eclipse.ui.workbench.ACTIVE_HYPERLINK_COLOR")) {
            Color hyperlinkColor = theme.get("javadocLink").getColor();
            this.darknessDependentBrightnessAdjustment(pluginKey, hyperlinkColor, 0.05f);
            return true;
        }
        return false;
    }

    private void darknessDependentBrightnessAdjustment(String pluginKey, Color baseColor, float b) {
        Color newColor = new Color(baseColor);
        if (newColor.isDarkColor()) {
            newColor.adjustHSB(0.0f, 0.0f, b);
        } else {
            newColor.adjustHSB(0.0f, 0.0f, -b);
        }
        this.preferences.put(pluginKey, newColor.asRGB());
    }
}

