/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.completion.proposals;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTCompletionProposal;

public class PFAutocompleteProposal
implements IDVTCompletionProposal,
ICompletionProposalExtension4 {
    private String replacementString;
    private ITextViewer viewer;
    private String prefix;
    private int offset;
    private boolean alreadyComputed;
    private int replacementOffset;
    private int cursorPosition;
    private String displayString;
    private int replacementLength;
    private String candidate;

    public PFAutocompleteProposal(ITextViewer viewer, String candidate, String prefix, int offset) {
        this.viewer = viewer;
        this.candidate = candidate;
        this.prefix = prefix;
        this.offset = offset;
    }

    public void apply(IDocument document) {
        try {
            this.internalComputeProposal();
            document.replace(this.replacementOffset, this.replacementLength, this.replacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void internalComputeProposal() {
        if (this.alreadyComputed) {
            return;
        }
        this.alreadyComputed = true;
        this.replacementString = this.candidate;
        this.displayString = this.candidate;
        this.replacementOffset = this.offset - this.prefix.length();
        this.replacementLength = this.prefix.length();
        Point selectedRange = this.viewer.getSelectedRange();
        if (this.replacementLength == 0 && selectedRange.x == this.replacementOffset) {
            this.replacementLength = selectedRange.y;
        }
        this.cursorPosition = this.replacementString.length();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementOffset + this.cursorPosition, 0);
    }

    public String getAdditionalProposalInfo() {
        return this.displayString;
    }

    public String getDisplayString() {
        this.internalComputeProposal();
        if (this.displayString != null) {
            return this.displayString;
        }
        return this.replacementString;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.POWER_DOMAIN);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public boolean isNoProposal() {
        return false;
    }
}

