/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.completion.proposals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalComputer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import ro.amiq.dvt.power.format.completion.proposals.PFAutocompleteProposal;
import ro.amiq.dvt.power.format.utils.DVTPFCommandUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class PFAutocompleteProposalComputer
implements IScriptCompletionProposalComputer {
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor pm) {
        try {
            if (context == null) {
                return Collections.singletonList(DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE);
            }
            ITextViewer viewer = context.getViewer();
            if (viewer == null) {
                return Collections.singletonList(DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE);
            }
            int offset = context.getInvocationOffset();
            if (offset < 0) {
                return Collections.singletonList(DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE);
            }
            CharSequence prefixChar = context.computeIdentifierPrefix();
            String prefix = "";
            prefix = prefixChar == null ? "" : prefixChar.toString();
            return this.computeProposals(viewer, offset, prefix);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.singletonList(DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE);
        }
    }

    private List<ICompletionProposal> computeProposals(ITextViewer viewer, int offset, String prefix) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        int matchType = 44;
        Object[] previousCharOffsetPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)viewer.getDocument(), (int)(offset - prefix.length() - 1), (boolean)false, (String)"__tcl_partitioning");
        int prevChar = 0;
        if (previousCharOffsetPair != null && previousCharOffsetPair[0] != null && previousCharOffsetPair[1] != null) {
            prevChar = ((Character)previousCharOffsetPair[0]).charValue();
        }
        if (45 == prevChar) {
            prefix = "-" + prefix;
            for (String candidate : DVTPFCommandUtils.ALL_COMMAND_ARGS) {
                if (!DVTStringUtil.regionMatches((String)candidate, (String)prefix, (int)matchType)) continue;
                PFAutocompleteProposal proposal = new PFAutocompleteProposal(viewer, candidate, prefix, offset);
                proposals.add((ICompletionProposal)proposal);
            }
        } else {
            for (String candidate : DVTPFCommandUtils.COMMAND_TOOLTIP_BY_NAME.keySet()) {
                if (!DVTStringUtil.regionMatches((String)candidate, (String)prefix, (int)matchType)) continue;
                PFAutocompleteProposal proposal = new PFAutocompleteProposal(viewer, candidate, prefix, offset);
                proposals.add((ICompletionProposal)proposal);
            }
        }
        return proposals;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext arg0, IProgressMonitor arg1) {
        return Collections.emptyList();
    }
}

