/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.highlight;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.internal.ui.text.TclTextTools;
import org.eclipse.dltk.tcl.ui.semantilhighlighting.ISemanticHighlightingExtension;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import ro.amiq.dvt.power.format.utils.DVTPFCommandUtils;

public class PFHighlightExtension
implements ISemanticHighlightingExtension {
    private SemanticHighlighting[] highlightings = new SemanticHighlighting[]{new TclTextTools.SH("DLTK_power_format_colors", null, "Power Format Commands"), new TclTextTools.SH("DLTK_power_format_argument_colors", null, "Power Format Command Arguments")};

    public SemanticHighlighting[] getHighlightings() {
        return this.highlightings;
    }

    public void processNode(ASTNode node, ISemanticHighlightingRequestor requestor) {
        this.addHighlightPositions(node, requestor);
    }

    private void addHighlightPositions(ASTNode node, ISemanticHighlightingRequestor requestor) {
        if (!(node instanceof TclStatement)) {
            return;
        }
        TclStatement statement = (TclStatement)node;
        List expressions = statement.getExpressions();
        if (expressions.size() <= 0) {
            return;
        }
        Expression commandExpression = statement.getAt(0);
        if (!(commandExpression instanceof SimpleReference)) {
            return;
        }
        SimpleReference simpleReference = (SimpleReference)commandExpression;
        if (!DVTPFCommandUtils.COMMAND_TOOLTIP_BY_NAME.containsKey(simpleReference.getName())) {
            return;
        }
        requestor.addPosition(commandExpression.start(), commandExpression.end(), "DLTK_power_format_colors");
        int i = 1;
        while (i < expressions.size()) {
            SimpleReference argSimpleRef;
            String argName;
            ASTNode argumentExpression = (ASTNode)expressions.get(i);
            if (argumentExpression instanceof SimpleReference && (argName = (argSimpleRef = (SimpleReference)argumentExpression).getName()) != null && argName.startsWith("-") && DVTPFCommandUtils.ALL_COMMAND_ARGS.contains(argName)) {
                requestor.addPosition(argumentExpression.start(), argumentExpression.end(), "DLTK_power_format_argument_colors");
            }
            ++i;
        }
    }
}

