/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.hover;

import org.eclipse.dltk.ui.text.hover.IScriptEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.power.format.hover.TclWordFinder;
import ro.amiq.dvt.power.format.utils.DVTPFCommandUtils;
import ro.amiq.dvt.power.format.utils.DVTPFPredefinedCommandInfo;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hover.DVTInformationControl;
import ro.amiq.dvt.utils.DVTStringUtil;

public class PFHover
implements IScriptEditorTextHover,
ITextHoverExtension {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String wordAtOffset;
        block4: {
            if (textViewer == null || textViewer.getDocument() == null) {
                return "";
            }
            try {
                IDocument document = textViewer.getDocument();
                wordAtOffset = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                if (wordAtOffset != null && !wordAtOffset.isEmpty()) break block4;
                return "";
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return "";
            }
        }
        return this.getHoverInfo(wordAtOffset);
    }

    private String getHoverInfo(String wordAtOffset) {
        DVTPFPredefinedCommandInfo commandInfo = (DVTPFPredefinedCommandInfo)DVTPFCommandUtils.COMMAND_TOOLTIP_BY_NAME.get(wordAtOffset);
        if (commandInfo == null) {
            return null;
        }
        String hover = commandInfo.getTooltipFormatedText();
        hover = DVTStringUtil.breakLongNonWhitespaceSequences((String)hover, (int)75, (char)'\n');
        return hover;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer == null || textViewer.getDocument() == null) {
            return new Region(0, 0);
        }
        return TclWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public void setEditor(IEditorPart editor) {
    }

    public void setPreferenceStore(IPreferenceStore store) {
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DVTInformationControl(parent, "Press 'F2' to focus");
            }
        };
    }
}

