/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.quick.fixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;

public abstract class AbstractPFQuickFix
extends WorkbenchMarkerResolution
implements ICompletionProposal {
    protected IMarker marker;
    protected int offset;
    protected String elementName;
    protected Position position;
    protected ITextViewer viewer;
    protected IDocument triggerDocument;
    protected IFile triggerFile;
    protected IEditorPart triggerEditor;

    public AbstractPFQuickFix(IMarker marker, ITextViewer viewer) {
        this.marker = marker;
        this.viewer = viewer;
    }

    public void setParameters(int offset, Position position, String elementName) {
        this.offset = offset;
        this.elementName = elementName;
        this.position = position;
    }

    public void run(IMarker marker) {
    }

    public void apply(IDocument document) {
        try {
            this.initTriggerElements(document);
            this.preApplyQuickFix(document);
            this.createQuickFixChanges(document);
            IFile[] affectedFiles = this.getAffectedFiles();
            if (affectedFiles == null) {
                throw new Exception();
            }
            DVTFileModificationValidator.validateEdit(null, (IFile[])affectedFiles);
            this.applyQuickFix(document);
            this.triggerEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            if (e instanceof CoreException && ((CoreException)((Object)e)).getStatus() == Status.CANCEL_STATUS) {
                return;
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
            MessageDialog.open((int)1, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"QuickFix Error", (String)"An error occurred while trying to apply the QuickFix proposal.", (int)0);
        }
    }

    protected IEditorPart getTextEditor() throws PartInitException {
        IEditorPart textEditor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)this.marker);
        return textEditor;
    }

    private void initTriggerElements(IDocument document) throws CoreException {
        this.triggerEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (this.triggerEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.triggerDocument = document;
        if (this.triggerDocument == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IEditorInput editorInput = this.triggerEditor.getEditorInput();
        if (editorInput == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.triggerFile = (IFile)editorInput.getAdapter(IResource.class);
        if (this.triggerFile == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.getDisplayString();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getLabel() {
        return this.getDisplayString();
    }

    public String getDescription() {
        return this.getAdditionalProposalInfo();
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return new IMarker[0];
    }

    protected void preApplyQuickFix(IDocument document) {
    }

    protected abstract void createQuickFixChanges(IDocument var1);

    protected abstract IFile[] getAffectedFiles();

    protected abstract void applyQuickFix(IDocument var1) throws Exception;
}

