/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.quick.fixes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.IScriptCorrectionContext;
import org.eclipse.dltk.ui.text.IScriptCorrectionProcessor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.dvt.power.format.quick.fixes.PfQuickFixUtils;
import ro.amiq.dvt.power.format.utils.PFQuickFixConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;

public class PFQuickFixProcessor
implements IScriptCorrectionProcessor {
    public boolean canFix(IScriptAnnotation annotation) {
        return true;
    }

    public boolean canFix(IMarker marker) {
        Object quickFixKind;
        block3: {
            try {
                Map attributes = marker.getAttributes();
                quickFixKind = attributes.get("QUICKFIX_KIND");
                if (quickFixKind instanceof Integer) break block3;
                return false;
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return PFQuickFixConstants.IMPLEMENTED_QUICK_FIXES.contains(quickFixKind);
    }

    public void computeQuickAssistProposals(IScriptAnnotation annotation, IScriptCorrectionContext context) {
    }

    public void computeQuickAssistProposals(IMarker marker, IScriptCorrectionContext context) {
        try {
            IQuickAssistInvocationContext invocationContext = context.getInvocationContext();
            if (invocationContext == null) {
                return;
            }
            ISourceViewer sourceViewer = invocationContext.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            int cursorOffset = invocationContext.getOffset();
            if (cursorOffset < 0) {
                return;
            }
            Map attributes = marker.getAttributes();
            Object quickFixKind = attributes.get("QUICKFIX_KIND");
            if (!(quickFixKind instanceof Integer)) {
                return;
            }
            Object elementName = attributes.get("QUICKFIX_ELEMENT_NAME");
            if (!(elementName instanceof String)) {
                return;
            }
            int markerStartOffset = marker.getAttribute("charStart", -1);
            int markerEndOffset = marker.getAttribute("charEnd", -1);
            if (markerStartOffset < 0 || markerEndOffset < 0) {
                return;
            }
            DVTPosition position = new DVTPosition(markerStartOffset, markerEndOffset - markerStartOffset);
            List<ICompletionProposal> proposals = this.computeQuickFixProposals((Integer)quickFixKind, marker, sourceViewer, cursorOffset, (Position)position, (String)elementName, new ArrayList<ICompletionProposal>());
            if (proposals == null || proposals.isEmpty()) {
                return;
            }
            for (ICompletionProposal proposal : proposals) {
                context.addProposal(proposal);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private List<ICompletionProposal> computeQuickFixProposals(int quickFixKind, IMarker marker, ISourceViewer viewer, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals) {
        return PfQuickFixUtils.getProposalsByKind(quickFixKind, marker, (ITextViewer)viewer, offset, position, elementName, existingProposals);
    }
}

