/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.quick.fixes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.power.format.quick.fixes.PFDidYouMeanMinDistComparator;
import ro.amiq.dvt.power.format.quick.fixes.PFDidYouMeanQuickFix;
import ro.amiq.dvt.power.format.utils.DVTPFCommandUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;

public class PfQuickFixUtils {
    public static List<ICompletionProposal> getProposalsByKind(final int quickFixKind, final IMarker marker, final ITextViewer viewer, final int offset, final Position position, final String elementName, final List<ICompletionProposal> existingProposals) {
        final AtomicBoolean done = new AtomicBoolean(false);
        final ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        Job computingQuickFixProposalJob = new Job("Compute PF Quick Fix Proposals Job"){

            protected IStatus run(IProgressMonitor monitor) {
                List<ICompletionProposal> proposalsByKindInternal = PfQuickFixUtils.getProposalsByKindInternal(quickFixKind, marker, viewer, offset, position, elementName, existingProposals, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                result.addAll(proposalsByKindInternal);
                done.set(true);
                return Status.OK_STATUS;
            }
        };
        computingQuickFixProposalJob.schedule();
        long busyIndicatorTimeout = System.currentTimeMillis() + 1500L;
        DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computingQuickFixProposalJob, (AtomicBoolean)done, (String)"Computing quick fix proposals...", (long)busyIndicatorTimeout);
        return result;
    }

    private static List<ICompletionProposal> getProposalsByKindInternal(int quickFixKind, IMarker marker, ITextViewer viewer, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, IProgressMonitor monitor) {
        try {
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            switch (quickFixKind) {
                case 1: {
                    int wordLength = position.getLength();
                    if (wordLength <= 2) break;
                    PfQuickFixUtils.addDidYouMeanProposal(marker, viewer, offset, position, elementName, proposals, existingProposals, monitor);
                }
            }
            return proposals;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private static void addDidYouMeanProposal(IMarker marker, ITextViewer viewer, int offset, Position position, String elementName, List<ICompletionProposal> proposals, List<ICompletionProposal> existingProposals, IProgressMonitor monitor) throws BadLocationException {
        if (position == null) {
            return;
        }
        int startOffset = position.getOffset();
        int length = position.getLength();
        if (startOffset < 0 || length == 0) {
            return;
        }
        String distanceTo = elementName;
        List<String> candidates = PfQuickFixUtils.getSortedCandidates(distanceTo);
        if (monitor.isCanceled()) {
            return;
        }
        int maxCandidates = Math.min(candidates.size(), 3);
        int i = 0;
        while (i < maxCandidates) {
            if (monitor.isCanceled()) {
                return;
            }
            String name = candidates.get(i);
            if (name != null && !name.isEmpty()) {
                Image image = DVTImages.imageCache.getImage(DVTImages.POWER_DOMAIN);
                PFDidYouMeanQuickFix proposal = new PFDidYouMeanQuickFix(marker, viewer, name, image, candidates.get(i));
                proposal.setParameters(offset, position, elementName);
                if (!existingProposals.contains((Object)proposal)) {
                    proposals.add(proposal);
                }
            }
            ++i;
        }
    }

    private static List<String> getSortedCandidates(String distanceTo) {
        ArrayList candidates = new ArrayList(DVTPFCommandUtils.COMMAND_TOOLTIP_BY_NAME.keySet());
        int matchType = 56;
        ArrayList<String> result = new ArrayList<String>();
        for (String candidate : candidates) {
            if (!DVTStringUtil.regionMatches((String)candidate, (String)distanceTo, (int)matchType)) continue;
            result.add(candidate);
        }
        Collections.sort(result, new PFDidYouMeanMinDistComparator(distanceTo));
        return result;
    }
}

