/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.tcl;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.tcl.core.TclLanguageToolkit;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.power.format.DVTPFModel;

public class DVTTclLangToolkit
extends TclLanguageToolkit {
    public boolean canValidateContent(IResource resource) {
        if (this.skipValidateContent(resource)) {
            return false;
        }
        return super.canValidateContent(resource);
    }

    private boolean skipValidateContent(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return true;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return true;
        }
        DVTPFModel pfModel = mixedLangProject.getPFModel();
        if (pfModel == null) {
            return true;
        }
        return pfModel.getParsedPfFileSet().contains(resource.getName());
    }
}

