/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viplugineclipse.Activator;
import com.mbartl.viplugineclipse.BookMarkHandler;
import com.mbartl.viplugineclipse.DocumentAdapter;
import com.mbartl.viplugineclipse.EditorImplementation;
import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.listeners.PageChangeListener;
import com.mbartl.viplugineclipse.undoextension.ViUndoManagerFactory;
import com.mbartl.viplugineclipse.viimplementation.layer.KeyVerifier;
import com.mbartl.viplugineclipse.viimplementation.layer.LayerInformation;
import com.mbartl.viplugineclipse.viimplementation.layer.ViCaret;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import com.mbartl.viplugineclipse.viimplementation.layer.ViStatusLineManager;
import com.mbartl.viplugineclipse.viimplementation.util.VersionUtils;
import java.lang.reflect.Method;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class ActivateLayer {
    private static PageChangeListener pageChangeListener = null;

    public static void activateLayer(IWorkbenchPart part) {
        Activator.getDefault().debug("ActivateLayer.activateLayer(): " + part);
        ITextEditor editor = ActivateLayer.checkAndGetEditor(part);
        if (editor == null) {
            return;
        }
        if (ActivateLayer.layerExists(editor)) {
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            ViLayer layer = ViLayerManager.getInstance().getLayerById(editor);
            if (document != null && document.get().equals(layer.getDocument().get())) {
                Activator.getDefault().debug("activated layer: " + editor);
                ViLayerManager.getInstance().activateLayer(editor);
            } else {
                Activator.getDefault().debug("reuse layer: " + editor.toString());
                ViLayerManager.getInstance().removeViLayer(editor);
                ActivateLayer.createNewLayer(editor);
            }
        } else {
            Activator.getDefault().debug("creating new layer: " + editor.toString());
            ActivateLayer.createNewLayer(editor);
        }
    }

    private static void createNewLayer(ITextEditor editor) {
        Method me = null;
        try {
            if (editor.getClass().getName().contains("CFML")) {
                Activator.getDefault().debug("CFML editor found");
                me = editor.getClass().getMethod("getViewer", new Class[0]);
            } else {
                me = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            }
            me.setAccessible(true);
            Object viewer = me.invoke((Object)editor, new Object[0]);
            ITextViewer textViewer = (ITextViewer)viewer;
            StyledText styledText = textViewer.getTextWidget();
            EditorImplementation editorImplementation = new EditorImplementation(editor, textViewer);
            ViStatusLineManager slm = new ViStatusLineManager(editor);
            DocumentAdapter documentAdapter = new DocumentAdapter(editor);
            LayerInformation info = new LayerInformation(editorImplementation, documentAdapter);
            info.setStatusLineManager(slm);
            info.setUndoManager(ViUndoManagerFactory.getUndoManager(editor.getClass().getName(), editorImplementation, textViewer));
            info.setCaret(new ViCaret(styledText));
            info.setBookmark(new BookMarkHandler(editor, editorImplementation));
            ViLayer layer = ViLayerManager.getInstance().createLayer(editor, info);
            documentAdapter.setLayer(layer);
            layer.setKeyListener(new KeyVerifier(layer, (ITextViewerExtension)viewer));
        }
        catch (Exception e) {
            Activator.getDefault().log("Exception while connecting viPlugin to editor", e);
        }
    }

    private static ITextEditor checkAndGetEditor(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        Object editor = null;
        if (Activator.getDefault().getDebug()) {
            Method[] declaredMethods = part.getClass().getDeclaredMethods();
            String debugText = "Declared Methods: \n";
            Method[] methodArray = declaredMethods;
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (!"void".equals(method.getReturnType())) {
                    debugText = String.valueOf(debugText) + method.getGenericReturnType() + ": " + method.getName() + "\n";
                }
                ++n2;
            }
            Activator.getDefault().debug(debugText);
        }
        if (part.getClass().getName().contains("jboss") && part.getClass().getName().contains("JSP")) {
            Activator.getDefault().debug("JBoss Tools JSF editor found");
            try {
                me = part.getClass().getMethod("getSourceEditor", new Class[0]);
                me.setAccessible(true);
                multiPageEditorPartActivePage = me.invoke((Object)part, new Object[0]);
                if (multiPageEditorPartActivePage instanceof ITextEditor) {
                    editor = multiPageEditorPartActivePage;
                }
            }
            catch (Exception e) {
                Activator.getDefault().log("Exception while checking editor", e);
            }
        } else if (part instanceof MultiPageEditorPart) {
            Activator.getDefault().debug("MultiPageEditorPart found");
            try {
                if (VersionUtils.isVersionHigherOrEqual("3.5.0")) {
                    if (pageChangeListener != null) {
                        pageChangeListener.removeListener();
                    }
                    pageChangeListener = new PageChangeListener((MultiPageEditorPart)part);
                    ((MultiPageEditorPart)part).addPageChangedListener((IPageChangedListener)pageChangeListener);
                }
                me = MultiPageEditorPart.class.getDeclaredMethod("getActiveEditor", new Class[0]);
                me.setAccessible(true);
                multiPageEditorPartActivePage = me.invoke((Object)part, new Object[0]);
                if (multiPageEditorPartActivePage instanceof ITextEditor) {
                    editor = multiPageEditorPartActivePage;
                }
            }
            catch (Exception e) {
                Activator.getDefault().log("Exception while checking editor", e);
            }
        } else if (part instanceof ITextEditor) {
            editor = part;
        }
        if (editor == null) {
            editor = part.getAdapter(ITextEditor.class);
        }
        if (editor != null) {
            String editorClassName = editor.getClass().getName();
            Activator.getDefault().debug("name = " + editorClassName);
        }
        return (ITextEditor)editor;
    }

    private static boolean layerExists(ITextEditor editor) {
        return ViLayerManager.getInstance().getLayerById(editor) != null;
    }
}

