/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viplugineclipse.EditorImplementation;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import ro.amiq.dvt.startup.core.DVTLogger;

public class BookMarkHandler {
    private final ITextEditor editor;
    private final EditorImplementation editorWrapper;

    public BookMarkHandler(ITextEditor editor, EditorImplementation editorWrapper) {
        this.editor = editor;
        this.editorWrapper = editorWrapper;
    }

    public void add(String name) {
        try {
            IEditorInput editorInput = this.editor.getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                return;
            }
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            IFile file = fileEditorInput.getFile();
            IMarker marker = this.getMarker(name);
            if (marker != null) {
                marker.delete();
            }
            HashMap map = new HashMap();
            MarkerUtilities.setMessage(map, (String)name);
            MarkerUtilities.setCharStart(map, (int)this.editorWrapper.getCaretPosition());
            MarkerUtilities.setCharEnd(map, (int)this.editorWrapper.getCaretPosition());
            if ("'".equals(name) || "invisible".equals(name)) {
                MarkerUtilities.createMarker((IResource)file, map, (String)"org.eclipse.core.resources.marker");
            } else {
                MarkerUtilities.createMarker((IResource)file, map, (String)"org.eclipse.core.resources.bookmark");
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public int getPosition(String name) {
        IMarker marker = this.getMarker(name);
        if (marker == null) {
            return 0;
        }
        return marker.getAttribute("charStart", 0);
    }

    public void goTo(String name) {
        IMarker marker = this.getMarker(name);
        if (marker == null) {
            return;
        }
        IWorkbenchPage page = this.editor.getSite().getPage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IMarker)marker, (boolean)OpenStrategy.activateOnOpen());
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private IMarker getMarker(String name) {
        IEditorInput editorInput = this.editor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
        Object file = null;
        file = name.equals(name.toLowerCase()) ? fileEditorInput.getFile() : fileEditorInput.getFile().getWorkspace().getRoot();
        try {
            IMarker[] markers = null;
            markers = "'".equals(name) || "invisible".equals(name) ? file.findMarkers("org.eclipse.core.resources.marker", true, 2) : file.findMarkers("org.eclipse.core.resources.bookmark", true, 2);
            int i = 0;
            while (i < markers.length) {
                if (markers[i].getResource().getType() == 1 && markers[i].getAttribute("message", "--").equals(name)) {
                    return markers[i];
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }
}

