/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viplugineclipse.Buffer;
import com.mbartl.viplugineclipse.viimplementation.interfaces.IDocumentAdapter;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import com.mbartl.viplugineclipse.viimplementation.util.Line;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import com.mbartl.viplugineclipse.viimplementation.util.TextUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DocumentAdapter
implements IDocumentListener,
IDocumentAdapter {
    private ViLayer layer;
    private DocumentEvent lastEvent = null;
    private boolean firstTime = true;
    private final ITextEditor editor;

    public DocumentAdapter(ITextEditor editor) {
        this.editor = editor;
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.addDocumentListener((IDocumentListener)this);
    }

    public String getTextOfLine(Line line) {
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        try {
            return document.get(line.getOffset(), line.getLength());
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public String getTextOfLinePos(int linePos) {
        return this.getTextOfLine(this.getLine(linePos));
    }

    @Override
    public String getText(int offset, int length) {
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        try {
            return document.get(offset, length);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public int getLength() {
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        return document.getLength();
    }

    @Override
    public void replace(int start, int length, String text) {
        this.notifyReadOnly();
        if (this.editor.isEditable()) {
            try {
                IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                document.replace(start, length, text);
                this.layer.getEditor().resetHighlighting();
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.lastEvent = event;
        if ((this.layer.isInInsertMode() || this.layer.isInReplaceMode()) && event.getText().length() > event.getLength()) {
            int start = Buffer.getInstance().getInsertBuffer().length() - event.getLength();
            if (start < 0) {
                start = 0;
            }
            int end = Buffer.getInstance().getInsertBuffer().length();
            Buffer.getInstance().getInsertBuffer().replace(start, end, event.getText());
        }
    }

    public DocumentEvent getLastEvent() {
        return this.lastEvent;
    }

    public void setLayer(ViLayer layer) {
        this.layer = layer;
    }

    @Override
    public void unregister() {
        IDocument document = this.getDocument();
        if (document != null) {
            document.removeDocumentListener((IDocumentListener)this);
        }
    }

    private IDocument getDocument() {
        IEditorInput editorInput;
        IDocumentProvider documentProvider = this.editor.getDocumentProvider();
        if (documentProvider != null && (editorInput = this.editor.getEditorInput()) != null) {
            return documentProvider.getDocument((Object)editorInput);
        }
        return null;
    }

    public int getNumberOfLines() {
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        return document.getNumberOfLines();
    }

    public int getNumberofLines(Region region) {
        int endLine = this.getLinePosOfOffset(region.getOffsetEnd());
        int startLine = this.getLinePosOfOffset(region.getOffset());
        return endLine - startLine + 1;
    }

    public Line getLine(int linePos) {
        try {
            IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            IRegion lineInformation = document.getLineInformation(linePos);
            String lineDelimiter = document.getLineDelimiter(linePos);
            if (lineDelimiter == null) {
                lineDelimiter = "";
            }
            return new Line(lineInformation.getOffset(), lineInformation.getLength(), lineDelimiter);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public Line getLineOfOffset(int offset) {
        try {
            IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            int linePos = document.getLineOfOffset(offset);
            IRegion lineInformation = document.getLineInformation(linePos);
            String lineDelimiter = document.getLineDelimiter(linePos);
            if (lineDelimiter == null) {
                lineDelimiter = "";
            }
            return new Line(lineInformation.getOffset(), lineInformation.getLength(), lineDelimiter);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public int getLinePosOfOffset(int offset) {
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        int realoffset = Math.min(document.getLength(), offset);
        try {
            return document.getLineOfOffset(realoffset);
        }
        catch (BadLocationException badLocationException) {
            return this.getLinePosOfOffset(offset - 1);
        }
    }

    public boolean isEmpty() {
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        return document.get().length() == 0;
    }

    public String getStandardDelimiter() {
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        try {
            return document.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {
            return TextUtils.DELIMITER_ON_THIS_PLATFORM;
        }
    }

    public String get() {
        return this.getText(0, this.getLength());
    }

    public char getCharAt(int idx) {
        return this.getText(idx, 1).charAt(0);
    }

    private boolean isReadOnly() {
        Object adapter = this.editor.getAdapter(IResource.class);
        if (!(adapter instanceof IFile)) {
            return false;
        }
        return ((IFile)adapter).isReadOnly();
    }

    public void notifyReadOnly() {
        if (this.editor.isEditable() && this.isReadOnly() && this.firstTime) {
            this.layer.getEditor().notifyModification();
            this.firstTime = false;
        }
    }

    public boolean isEditable() {
        return this.editor.isEditable();
    }
}

