/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viplugineclipse.Activator;
import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.actions.AddOneLevelOfIndentation;
import com.mbartl.viplugineclipse.actions.CycleEditorsAction;
import com.mbartl.viplugineclipse.actions.DecrementNumberAction;
import com.mbartl.viplugineclipse.actions.EraseBackOneWord;
import com.mbartl.viplugineclipse.actions.EraseOneLevelOfIndentation;
import com.mbartl.viplugineclipse.actions.HalfPageUpAction;
import com.mbartl.viplugineclipse.actions.IncrementNumberAction;
import com.mbartl.viplugineclipse.actions.PageDownAction;
import com.mbartl.viplugineclipse.actions.PageUpAction;
import com.mbartl.viplugineclipse.actions.PasteBufferInInsertMode;
import com.mbartl.viplugineclipse.actions.ScrollLineDownAction;
import com.mbartl.viplugineclipse.actions.ScrollLineUpAction;
import com.mbartl.viplugineclipse.actions.SwitchToCommandMode;
import com.mbartl.viplugineclipse.actions.SwitchToVisualBlockMode;
import com.mbartl.viplugineclipse.foldingextension.FoldingExtensionFactory;
import com.mbartl.viplugineclipse.foldingextension.IFoldingExtension;
import com.mbartl.viplugineclipse.preferences.PreferenceHelper;
import com.mbartl.viplugineclipse.utils.ActionUtils;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import com.mbartl.viplugineclipse.viimplementation.util.VersionUtils;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;

public class EditorImplementation
implements MouseListener {
    private final ITextEditor editor;
    private final ITextViewer viewer;
    private final IFoldingExtension foldingExtension;
    private final StyledText styledText;
    private Vector<Region> lastSearchHighlightingRegions = new Vector();
    private int blockSelectionEndpoint = 0;

    public EditorImplementation(ITextEditor editor, ITextViewer viewer) {
        this.editor = editor;
        this.viewer = viewer;
        this.styledText = viewer.getTextWidget();
        this.foldingExtension = FoldingExtensionFactory.getFoldingExtension(editor, viewer);
        editor.setAction("com.mbartl.viplugineclipse.actions.SwitchToCommandMode", (IAction)new SwitchToCommandMode());
        editor.setAction("com.mbartl.viplugineclipse.actions.EraseBackOneWord", (IAction)new EraseBackOneWord());
        editor.setAction("com.mbartl.viplugineclipse.actions.EraseOneLevelOfIndentation", (IAction)new EraseOneLevelOfIndentation());
        editor.setAction("com.mbartl.viplugineclipse.actions.AddOneLevelOfIndentation", (IAction)new AddOneLevelOfIndentation());
        editor.setAction("com.mbartl.viplugineclipse.actions.PasteBufferInInsertMode", (IAction)new PasteBufferInInsertMode());
        editor.setAction("com.mbartl.viplugineclipse.actions.HalfPageUp", (IAction)new HalfPageUpAction());
        editor.setAction("com.mbartl.viplugineclipse.actions.PageUp", (IAction)new PageUpAction());
        editor.setAction("com.mbartl.viplugineclipse.actions.PageDown", (IAction)new PageDownAction());
        editor.setAction("com.mbartl.viplugineclipse.actions.ScrollLineUp", (IAction)new ScrollLineUpAction());
        editor.setAction("com.mbartl.viplugineclipse.actions.ScrollLineDown", (IAction)new ScrollLineDownAction());
        editor.setAction("com.mbartl.viplugineclipse.actions.CycleEditors", (IAction)new CycleEditorsAction());
        editor.setAction("com.mbartl.viplugineclipse.actions.SwitchToVisualBlockMode", (IAction)new SwitchToVisualBlockMode());
        editor.setAction("com.mbartl.viplugineclipse.actions.IncrementNumber", (IAction)new IncrementNumberAction());
        editor.setAction("com.mbartl.viplugineclipse.actions.DecrementNumber", (IAction)new DecrementNumberAction());
        this.styledText.addMouseListener((MouseListener)this);
    }

    public void setCaretPosition(int pos) {
        int currentPos = this.getCaretPosition();
        if (pos != currentPos) {
            boolean forward = currentPos < pos;
            int validPos = this.foldingExtension.getValidCaretPosition(pos, forward);
            this.styledText.setCaretOffset(validPos);
            this.styledText.showSelection();
        }
    }

    public void setCaretPositionAndOpenFoldIfNecessary(int pos) {
        int currentPos = this.getCaretPosition();
        if (pos != currentPos) {
            this.foldingExtension.exposeModelRegion(pos, 1);
            this.setCaretPosition(pos);
        }
    }

    public int getCaretPosition() {
        int pos = this.foldingExtension.cursorOffset2DocumentOffset(this.styledText.getCaretOffset());
        if (pos == -1) {
            return this.styledText.getCaretOffset();
        }
        return pos;
    }

    public void quit(boolean forceClose) {
        try {
            if (forceClose || !this.editor.isSaveOnCloseNeeded()) {
                this.editor.close(false);
            } else {
                MessageDialog.openInformation((Shell)this.editor.getSite().getWorkbenchWindow().getShell(), (String)"Can't close buffer", (String)"There are unsaved changes. To override use :q!");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void save() {
        this.callAction("SAVE");
    }

    public int getTopIndex() {
        return this.viewer.getTopIndex();
    }

    public int getBottomIndex() {
        return this.viewer.getBottomIndex();
    }

    public void copySelectionToClipboard(Region region) {
        try {
            Clipboard clipboard = new Clipboard(Display.getDefault());
            String contents = this.viewer.getDocument().get(region.getOffset(), region.getLength());
            try {
                clipboard.setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError sWTError) {}
            clipboard.dispose();
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setVisualSelection(int start, int end) {
        int widgetOffsetStart = this.foldingExtension.documentOffset2CursorOffset(start);
        int widgetOffsetEnd = this.foldingExtension.documentOffset2CursorOffset(end);
        if (this.styledText.getBlockSelection()) {
            this.blockSelectionEndpoint = end;
        }
        this.styledText.setSelection(widgetOffsetStart, widgetOffsetEnd);
    }

    public Region getVisualSelection() {
        ITextSelection sel = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        return new Region(sel.getOffset(), sel.getLength());
    }

    public Vector<Region> getBlockSelections() {
        Vector<Region> regions = new Vector<Region>();
        int[] selectionRanges = this.styledText.getSelectionRanges();
        int i = 0;
        while (i < selectionRanges.length) {
            regions.add(new Region(selectionRanges[i], selectionRanges[i + 1]));
            i += 2;
        }
        return regions;
    }

    public void revertToSaved() {
        this.editor.doRevertToSaved();
    }

    public void scrollToLine(int line) {
        this.viewer.setTopIndex(line);
    }

    public void highlightSearchRegions(Vector<Region> regions) {
        this.lastSearchHighlightingRegions = regions;
        int i = 0;
        while (i < regions.size()) {
            Region region = regions.get(i);
            this.foldingExtension.exposeModelRegion(region.getOffset(), 1);
            region = this.foldingExtension.model2viewRegion(region);
            if (region != null) {
                StyleRange style = new StyleRange(region.getOffset(), region.getLength(), PreferenceHelper.getColor("foreground_highlighting"), PreferenceHelper.getColor("background_highlighting"));
                this.styledText.setStyleRange(style);
            }
            ++i;
        }
    }

    public void resetHighlighting() {
        if (this.lastSearchHighlightingRegions.size() != 0) {
            this.lastSearchHighlightingRegions = new Vector();
            this.viewer.invalidateTextPresentation();
        }
    }

    public void clearHighlighting() {
        this.lastSearchHighlightingRegions = new Vector();
        this.viewer.invalidateTextPresentation();
    }

    public boolean callAction(String actionId) {
        Activator.getDefault().debug("callAction = " + actionId);
        IAction action = null;
        if ("NEW_LINE_BELOW".equals(actionId)) {
            action = this.editor.getAction("SmartEnter");
        } else if (actionId.equals("NEW_LINE_ABOVE")) {
            action = this.editor.getAction("SmartEnterInverse");
        } else {
            if (actionId.equals("OPEN_DECLARATION")) {
                ActionUtils.callHandlerAction("org.eclipse.jdt.ui.edit.text.java.open.editor");
                return true;
            }
            if ("INDENT_LINE".equals(actionId)) {
                action = this.editor.getAction("Indent");
            } else if ("UNDO".equals(actionId)) {
                action = this.editor.getAction(ActionFactory.UNDO.getId());
            } else if ("REDO".equals(actionId)) {
                action = this.editor.getAction(ActionFactory.REDO.getId());
            } else if ("SAVE".equals(actionId)) {
                action = this.editor.getAction(ActionFactory.SAVE.getId());
            } else {
                if ("FOLD_OPEN".equals(actionId)) {
                    ActionUtils.callHandlerAction("org.eclipse.ui.edit.text.folding.expand");
                    return true;
                }
                if ("FOLD_CLOSE".equals(actionId)) {
                    ActionUtils.callHandlerAction("org.eclipse.ui.edit.text.folding.collapse");
                    return true;
                }
                if ("FORMAT_TEXT".equals(actionId)) {
                    ActionUtils.callHandlerAction("org.eclipse.jdt.ui.edit.text.java.format");
                    return true;
                }
                if ("FOLD_OPEN_ALL".equals(actionId)) {
                    this.foldingExtension.exposeModelRegion(0, this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).getLength());
                    return true;
                }
            }
        }
        if (action != null) {
            if (action.isEnabled()) {
                action.run();
            }
            return true;
        }
        ActionUtils.callHandlerAction(actionId);
        Activator.getDefault().debug("Action NOT found!");
        return false;
    }

    public String getClipboardContent() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        TextTransfer textTransfer = TextTransfer.getInstance();
        String content = (String)clipboard.getContents((Transfer)textTransfer);
        clipboard.dispose();
        return content;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        ViLayer layer = ViLayerManager.getInstance().getCurrentLayer();
        if (layer == null) {
            return;
        }
        layer.getCursorInLinePosition().setCurrentCursorInLinePosition();
    }

    public void mouseUp(MouseEvent e) {
    }

    public IFile getFilePath() {
        IEditorInput input = this.editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return fileInput.getFile();
        }
        return null;
    }

    public void moveUp(boolean inVisualMode) {
        if (inVisualMode) {
            this.styledText.invokeAction(0x1020001);
        } else {
            this.styledText.invokeAction(0x1000001);
        }
    }

    public void moveDown(boolean inVisualMode) {
        if (inVisualMode) {
            this.styledText.invokeAction(0x1020002);
        } else {
            this.styledText.invokeAction(0x1000002);
        }
    }

    public void setBlockSelection(boolean blockSelection) {
        if (VersionUtils.isVersionHigherOrEqual("3.5.0") && !this.styledText.isDisposed()) {
            this.styledText.setBlockSelection(blockSelection);
        }
    }

    public void reduceBlockSelectionToLeft() {
        Vector<Region> blockSelections = this.getBlockSelections();
        int start = blockSelections.firstElement().getOffset();
        int end = blockSelections.get(blockSelections.size() - 1).getOffset();
        this.setVisualSelection(start, end);
    }

    public void reduceBlockSelectionToRight() {
        Vector<Region> blockSelections = this.getBlockSelections();
        int start = blockSelections.firstElement().getOffsetEnd();
        int end = blockSelections.get(blockSelections.size() - 1).getOffsetEnd();
        this.setVisualSelection(start, end);
    }

    public void cutBlock() {
        this.styledText.cut();
    }

    public void copyBlock() {
        this.styledText.copy();
    }

    public void pasteBlock() {
        this.styledText.paste();
    }

    public int getNumerOfLinesInWidget() {
        return this.styledText.getLineCount();
    }

    public int getTabWidth() {
        return this.styledText.getTabs();
    }

    public void notifyModification() {
        this.styledText.replaceTextRange(0, 0, "");
    }

    public boolean isCursorOutOfView() {
        int caretOffset = this.getCaretPosition();
        return caretOffset >= this.viewer.getTopIndexStartOffset() && caretOffset <= this.viewer.getBottomIndexEndOffset();
    }

    public int getBlockSelectionEndPoint() {
        return this.blockSelectionEndpoint;
    }
}

