/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.utils.ActionUtils;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;

public class EditorManager {
    private final IWorkbenchWindow window;

    public EditorManager(IWorkbenchWindow window) {
        this.window = window;
    }

    public void gotoNextEditorTab() {
        ViLayer currentLayer = ViLayerManager.getInstance().getCurrentLayer();
        ActionUtils.callHandlerAction("org.eclipse.ui.navigate.nextTab");
        ViLayer currentLayer2 = ViLayerManager.getInstance().getCurrentLayer();
        if (currentLayer == currentLayer2) {
            this.gotoEditor(1);
        }
    }

    public void gotoPreviousEditorTab() {
        ViLayer currentLayer = ViLayerManager.getInstance().getCurrentLayer();
        ActionUtils.callHandlerAction("org.eclipse.ui.navigate.previousTab");
        ViLayer currentLayer2 = ViLayerManager.getInstance().getCurrentLayer();
        if (currentLayer == currentLayer2) {
            this.gotoLastEditorTab();
        }
    }

    public void nextProblem() {
        ActionUtils.callHandlerAction("org.eclipse.ui.navigate.next");
    }

    public void saveAll() {
        IEditorReference[] references = this.window.getActivePage().getEditorReferences();
        int i = 0;
        while (i < references.length) {
            IEditorPart part = references[i].getEditor(false);
            if (part != null) {
                IProgressMonitor pm = part.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
                part.doSave(pm);
            }
            ++i;
        }
    }

    public void gotoEditor(int id) {
        IEditorReference[] references = this.window.getActivePage().getEditorReferences();
        if (id <= references.length) {
            this.window.getActivePage().activate(references[id - 1].getPart(true));
            if (id == 1) {
                ActionUtils.callHandlerAction("org.eclipse.ui.navigate.previousTab");
            }
        }
    }

    public void gotoLastEditorTab() {
        IEditorReference[] references = this.window.getActivePage().getEditorReferences();
        this.window.getActivePage().activate(references[references.length - 1].getPart(true));
        ActionUtils.callHandlerAction("org.eclipse.ui.navigate.nextTab");
    }

    public void setFullScreen() {
        ActionUtils.callHandlerAction("org.eclipse.ui.window.maximizePart");
    }

    public void gotoPreviousOpenedEditor() {
        ActionUtils.callHandlerAction("org.eclipse.ui.window.nextEditor");
    }
}

