/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viplugineclipse.Activator;
import com.mbartl.viplugineclipse.BufferEvaluator;
import com.mbartl.viplugineclipse.EditorManager;
import com.mbartl.viplugineclipse.viimplementation.layer.LayerInformation;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;

public class ViLayerManager {
    private EditorManager editorManager;
    private final Map<ITextEditor, ViLayer> layers = new HashMap<ITextEditor, ViLayer>();
    private ITextEditor _currentEditor;
    private static ViLayerManager _manager = null;

    private ViLayerManager() {
    }

    public static ViLayerManager getInstance() {
        if (_manager == null) {
            _manager = new ViLayerManager();
        }
        return _manager;
    }

    public boolean activateLayer(ITextEditor editor) {
        ViLayer currViLayer;
        Activator.getDefault().debug("ViLayerManager: activate layer: " + editor.toString());
        if (!editor.equals(this._currentEditor) && (currViLayer = this.getLayerById(editor)) != null) {
            this._currentEditor = editor;
            BufferEvaluator.getInstance().rehighlightLastSearch();
        }
        return false;
    }

    public ViLayer createLayer(ITextEditor editor, LayerInformation info) {
        Activator.getDefault().debug("ViLayerManager: create layer: " + editor.toString());
        if (!editor.equals(this._currentEditor)) {
            ViLayer currViLayer = this.getLayerById(editor);
            if (currViLayer == null) {
                currViLayer = new ViLayer(info);
                this.layers.put(editor, currViLayer);
            }
            this._currentEditor = editor;
            BufferEvaluator.getInstance().rehighlightLastSearch();
        }
        return this.getCurrentLayer();
    }

    public void removeAllLayers() {
        for (ViLayer layer : this.layers.values()) {
            layer.unLoad();
        }
        _manager = null;
    }

    public void removeViLayer(ITextEditor editor) {
        ViLayer viLayer = this.getLayerById(editor);
        if (viLayer != null) {
            viLayer.unLoad();
            this.layers.remove(editor);
            if (editor.equals(this._currentEditor)) {
                this._currentEditor = null;
            }
        }
    }

    public ViLayer getLayerById(ITextEditor editor) {
        return this.layers.get(editor);
    }

    public ViLayer getCurrentLayer() {
        return this.getLayerById(this._currentEditor);
    }

    public void setEditorManager(EditorManager editorManager) {
        this.editorManager = editorManager;
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public boolean isFullVersion() {
        return DVTPlugin.getDefault().collect().c();
    }
}

