/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.actions;

import com.mbartl.viplugineclipse.BufferEvaluator;
import com.mbartl.viplugineclipse.DocumentAdapter;
import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import com.mbartl.viplugineclipse.viimplementation.util.Line;
import com.mbartl.viplugineclipse.viimplementation.util.Macro;
import com.mbartl.viplugineclipse.viimplementation.util.TextUtils;
import com.mbartl.viplugineclipse.viimplementation.util.ViKeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;

public class DecrementNumberAction
extends Action {
    public static final String ACTIONID = "com.mbartl.viplugineclipse.actions.DecrementNumber";

    public DecrementNumberAction() {
        this.setActionDefinitionId(ACTIONID);
    }

    public void run() {
        ViLayer layer = ViLayerManager.getInstance().getCurrentLayer();
        if (layer != null) {
            Line line;
            DocumentAdapter document = layer.getDocument();
            int pos = layer.getEditor().getCaretPosition();
            if (pos >= (line = document.getLineOfOffset(pos)).getOffsetEnd()) {
                return;
            }
            String text = document.getText(line.getOffset(), line.getLength());
            int start = TextUtils.getStartOfNumber(text, pos - line.getOffset());
            Pattern pattern = Pattern.compile("-?\\d+");
            Matcher matcher = pattern.matcher(text);
            if (matcher.find(start)) {
                String nextNumber = matcher.group();
                int decrementedNumber = Integer.parseInt(nextNumber);
                document.replace(line.getOffset() + matcher.start(), nextNumber.length(), String.valueOf(--decrementedNumber));
                layer.getEditor().setCaretPosition(line.getOffset() + matcher.start());
                Macro macro = BufferEvaluator.getInstance().getMacro();
                if (macro != null) {
                    ViKeyEvent viKeyEvent = new ViKeyEvent('x', 0, 1);
                    macro.add(viKeyEvent);
                }
            }
        }
    }
}

