/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.foldingextension;

import com.mbartl.viplugineclipse.foldingextension.IFoldingExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.texteditor.ITextEditor;

class FoldingExtension
implements IFoldingExtension {
    private final ITextEditor _editor;
    private final ITextViewer _viewer;
    private ITextViewerExtension5 _extension;
    private final IDocument _document;

    public FoldingExtension(ITextEditor editor, ITextViewer viewer) throws Exception {
        this._editor = editor;
        this._viewer = viewer;
        this._document = this._editor.getDocumentProvider().getDocument((Object)this._editor.getEditorInput());
        if (this._viewer == null || !(this._viewer instanceof ITextViewerExtension5)) {
            throw new Exception("No Folding Extension enabled!");
        }
        this._extension = (ITextViewerExtension5)this._viewer;
    }

    @Override
    public int getValidCaretPosition(int pos, boolean forward) {
        int newPos = this._extension.modelOffset2WidgetOffset(pos);
        if (newPos != -1) {
            return newPos;
        }
        IRegion[] reg = this._extension.getCoveredModelRanges((IRegion)new Region(0, this._document.getLength()));
        if (forward) {
            int i = 0;
            while (i < reg.length) {
                if (reg[i].getOffset() > pos) {
                    return this._extension.modelOffset2WidgetOffset(reg[i].getOffset());
                }
                ++i;
            }
        } else {
            int i = reg.length - 1;
            while (i >= 0) {
                if (pos >= reg[i].getOffset()) {
                    return this._extension.modelOffset2WidgetOffset(reg[i].getOffset() + reg[i].getLength() - this.getDelimiter().length());
                }
                --i;
            }
        }
        return newPos;
    }

    private String getDelimiter() {
        String delim = null;
        try {
            delim = this._document.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (delim == null) {
            delim = this._document.getLegalLineDelimiters()[0];
        }
        return delim;
    }

    @Override
    public int cursorOffset2DocumentOffset(int cursorPosition) {
        return this._extension.widgetOffset2ModelOffset(cursorPosition);
    }

    @Override
    public com.mbartl.viplugineclipse.viimplementation.util.Region model2viewRegion(com.mbartl.viplugineclipse.viimplementation.util.Region region) {
        IRegion[] reg = this._extension.getCoveredModelRanges((IRegion)new Region(region.getOffset(), region.getLength()));
        if (reg != null) {
            int start = this._extension.modelOffset2WidgetOffset(region.getOffset());
            int end = this._extension.modelOffset2WidgetOffset(region.getOffsetEnd());
            return new com.mbartl.viplugineclipse.viimplementation.util.Region(start, end - start);
        }
        return null;
    }

    @Override
    public int documentOffset2CursorOffset(int pos) {
        return this._extension.modelOffset2WidgetOffset(pos);
    }

    @Override
    public void exposeModelRegion(int pos, int length) {
        this._extension.exposeModelRange((IRegion)new Region(pos, length));
    }
}

