/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.preferences;

import com.mbartl.viplugineclipse.Activator;
import com.mbartl.viplugineclipse.preferences.AbbreviationsPreferencePage;
import com.mbartl.viplugineclipse.preferences.IMapPreferencePage;
import com.mbartl.viplugineclipse.preferences.MapPreferencePage;
import com.mbartl.viplugineclipse.preferences.PreferencePage;
import com.mbartl.viplugineclipse.preferences.SetBoolean;
import com.mbartl.viplugineclipse.preferences.SetInt;
import com.mbartl.viplugineclipse.preferences.SetPrefCommand;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;

public final class PreferenceService {
    private static PreferenceService _preferenceService = null;
    private final Map<String, SetPrefCommand> preferencesCommands = new HashMap<String, SetPrefCommand>();

    private void initCommandMappings() {
        SetPrefCommand c = null;
        c = new SetBoolean("ignorecase", true);
        this.preferencesCommands.put("ic", c);
        this.preferencesCommands.put("ignorecase", c);
        c = new SetBoolean("ignorecase", false);
        this.preferencesCommands.put("noic", c);
        this.preferencesCommands.put("noignorecase", c);
        c = new SetBoolean("ignorecase", true);
        this.preferencesCommands.put("scs", c);
        this.preferencesCommands.put("nosmartcase", c);
        c = new SetBoolean("ignorecase", false);
        this.preferencesCommands.put("noscs", c);
        this.preferencesCommands.put("nosmartcase", c);
        c = new SetBoolean("vimcursor", true);
        this.preferencesCommands.put("vc", c);
        this.preferencesCommands.put("vimcursor", c);
        c = new SetBoolean("vimcursor", false);
        this.preferencesCommands.put("novc", c);
        this.preferencesCommands.put("novimcursor", c);
        c = new SetInt("shiftwidth");
        this.preferencesCommands.put("shiftwidth", c);
        this.preferencesCommands.put("sw", c);
        c = new SetBoolean(EditorsUI.getPreferenceStore(), "spacesForTabs", true);
        this.preferencesCommands.put("et", c);
        this.preferencesCommands.put("expandtab", c);
        c = new SetBoolean(EditorsUI.getPreferenceStore(), "spacesForTabs", false);
        this.preferencesCommands.put("noet", c);
        this.preferencesCommands.put("noexpandtab", c);
        c = new SetBoolean("hlsearch", true);
        this.preferencesCommands.put("hlsearch", c);
        this.preferencesCommands.put("hls", c);
        c = new SetBoolean("hlsearch", false);
        this.preferencesCommands.put("nohlsearch", c);
        this.preferencesCommands.put("nohls", c);
        c = new SetBoolean("incsearch", true);
        this.preferencesCommands.put("incsearch", c);
        c = new SetBoolean("incsearch", false);
        this.preferencesCommands.put("noincsearch", c);
        c = new SetInt("undolevels");
        this.preferencesCommands.put("undolevels", c);
        c = new SetBoolean("copytoclipboard", true);
        this.preferencesCommands.put("copytoclipboard", c);
        c = new SetBoolean("copytoclipboard", false);
        this.preferencesCommands.put("nocopytoclipboard", c);
        c = new SetBoolean("wrapsearch", true);
        this.preferencesCommands.put("ws", c);
        c = new SetBoolean("wrapsearch", true);
        this.preferencesCommands.put("wrapscan", c);
        c = new SetBoolean("wrapsearch", false);
        this.preferencesCommands.put("nows", c);
        c = new SetBoolean("wrapsearch", false);
        this.preferencesCommands.put("nowrapscan", c);
    }

    private PreferenceService() {
        this.initCommandMappings();
    }

    public static PreferenceService getInstance() {
        if (_preferenceService == null) {
            _preferenceService = new PreferenceService();
        }
        return _preferenceService;
    }

    public void executeSetCommand(String name, String value) {
        SetPrefCommand command = this.preferencesCommands.get(name);
        if (command != null) {
            command.execute(value);
        }
    }

    public void showPreferences() {
        PreferenceManager mgr = new PreferenceManager();
        mgr.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePage()));
        mgr.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new AbbreviationsPreferencePage()));
        mgr.addToRoot((IPreferenceNode)new PreferenceNode("3", (IPreferencePage)new MapPreferencePage()));
        mgr.addToRoot((IPreferenceNode)new PreferenceNode("4", (IPreferencePage)new IMapPreferencePage()));
        PreferenceDialog dialog = new PreferenceDialog(Display.getCurrent().getActiveShell(), mgr);
        dialog.create();
        dialog.setMessage("viPlugin preferences");
        dialog.open();
    }

    public void setString(String name, String value) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue(name, value);
    }

    public boolean getBoolean(String name) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean(name);
    }

    public String getString(String name) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getString(name);
    }

    public int getInt(String name) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getInt(name);
    }

    public boolean isSpacesForTabes() {
        return EditorsUI.getPreferenceStore().getBoolean("spacesForTabs");
    }

    public void setLineNumbers(boolean on) {
        EditorsUI.getPreferenceStore().setValue("lineNumberRuler", on);
    }

    public void setShowWhiteSpace(boolean on) {
        EditorsUI.getPreferenceStore().setValue("showWhitespaceCharacters", on);
    }
}

