/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.undoextension;

import com.mbartl.viplugineclipse.Activator;
import com.mbartl.viplugineclipse.EditorImplementation;
import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.interfaces.IUndoManager;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.ITextViewer;

class ViDefaultUndoManager
implements IUndoManager {
    private final org.eclipse.jface.text.IUndoManager _undoManager;
    private final ITextViewer _viewer;
    private final EditorImplementation _editor;

    public ViDefaultUndoManager(EditorImplementation editor, ITextViewer viewer) {
        this._viewer = viewer;
        this._editor = editor;
        Activator.getDefault().debug("UndoManager = DefaultUndoManager");
        int levels = PreferenceService.getInstance().getInt("undolevels");
        this._undoManager = new DefaultUndoManager(levels);
        viewer.setUndoManager(this._undoManager);
        this._undoManager.connect(this._viewer);
    }

    @Override
    public void redo() {
        this._editor.callAction("REDO");
        this._editor.setCaretPosition(this._editor.getVisualSelection().getOffset());
    }

    @Override
    public void undo() {
        this._editor.callAction("UNDO");
        this._editor.setCaretPosition(this._editor.getVisualSelection().getOffset());
    }

    @Override
    public void beginCompoundChange() {
        this._undoManager.beginCompoundChange();
    }

    @Override
    public void endCompoundChange() {
        this._undoManager.endCompoundChange();
    }

    @Override
    public boolean canUndo() {
        return this._undoManager.undoable();
    }

    @Override
    public void setUndoLevels(int levels) {
        this._undoManager.setMaximalUndoLevel(levels);
    }
}

