/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.undoextension;

import com.mbartl.viplugineclipse.Activator;
import com.mbartl.viplugineclipse.EditorImplementation;
import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.preferences.PreferenceService;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;

class ViUndoManager
implements com.mbartl.viplugineclipse.viimplementation.interfaces.IUndoManager {
    private final IUndoManager _undoManager;
    private final ITextViewer _viewer;
    private final EditorImplementation _editor;
    private boolean startedCompoundChange = false;

    public ViUndoManager(EditorImplementation editor, ITextViewer viewer) {
        this._viewer = viewer;
        this._editor = editor;
        int levels = PreferenceService.getInstance().getInt("undolevels");
        if (this._viewer != null && this._viewer instanceof ITextViewerExtension6) {
            Activator.getDefault().debug("UndoManager = ViUndoManager (ITextViewer6)");
            ITextViewerExtension6 _extension = (ITextViewerExtension6)this._viewer;
            this._undoManager = _extension.getUndoManager();
            this._undoManager.setMaximalUndoLevel(levels);
        } else {
            Activator.getDefault().debug("UndoManager = ViUndoManager / DefaultUndoManager");
            this._undoManager = new DefaultUndoManager(levels);
            viewer.setUndoManager(this._undoManager);
            this._undoManager.connect(this._viewer);
        }
    }

    @Override
    public void redo() {
        this._editor.callAction("REDO");
        DocumentEvent lastEvent = ViLayerManager.getInstance().getCurrentLayer().getDocument().getLastEvent();
        if (lastEvent != null) {
            this._editor.setCaretPosition(lastEvent.getOffset());
        }
    }

    @Override
    public void undo() {
        this._editor.callAction("UNDO");
        DocumentEvent lastEvent = ViLayerManager.getInstance().getCurrentLayer().getDocument().getLastEvent();
        if (lastEvent != null) {
            this._editor.setCaretPosition(lastEvent.getOffset());
        }
    }

    @Override
    public void beginCompoundChange() {
        if (!this.startedCompoundChange) {
            this.startedCompoundChange = true;
            this._undoManager.beginCompoundChange();
        }
    }

    @Override
    public void endCompoundChange() {
        if (this.startedCompoundChange) {
            this.startedCompoundChange = false;
            this._undoManager.endCompoundChange();
        }
    }

    @Override
    public boolean canUndo() {
        return this._undoManager.undoable();
    }

    @Override
    public void setUndoLevels(int levels) {
        this._undoManager.setMaximalUndoLevel(levels);
    }
}

