/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.utils;

import com.mbartl.viplugineclipse.EditorImplementation;
import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.utils.MessageDialogUtils;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import java.io.File;
import java.io.IOException;

public class ExecuteVim {
    public static void executeVim() {
        String[] vimargs = PreferenceService.getInstance().getString("vimargs").split(" ");
        String[] vimExecutable = new String[3 + vimargs.length];
        vimExecutable[0] = PreferenceService.getInstance().getString("vim");
        int i = 0;
        while (i < vimargs.length) {
            vimExecutable[1 + i] = vimargs[i];
            ++i;
        }
        ViLayer layer = ViLayerManager.getInstance().getCurrentLayer();
        EditorImplementation editor = layer.getEditor();
        int line = layer.getDocument().getLinePosOfOffset(editor.getCaretPosition()) + 1;
        int column = layer.getCursorInLinePosition().getCursorInLinePosition() + 1;
        vimExecutable[vimExecutable.length - 2] = "+call cursor(" + line + ", " + column + ")";
        vimExecutable[vimExecutable.length - 1] = editor.getFilePath().getLocation().toOSString();
        try {
            editor.save();
            File projectPath = editor.getFilePath().getProject().getLocation().toFile();
            Runtime.getRuntime().exec(vimExecutable, null, projectPath);
        }
        catch (IOException e) {
            MessageDialogUtils.showDialog("Can't start VIM", String.valueOf(e.getMessage()) + "\n" + vimExecutable[0] + " " + editor.getFilePath());
        }
    }
}

