/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.search.GetOccurences;
import com.mbartl.viplugineclipse.viimplementation.search.Search;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import java.util.Vector;

public class HighlightWord
extends Command {
    private final String word;
    private final boolean all;
    private Vector<Region> occurences;

    public HighlightWord(String word, boolean all) {
        this.word = word;
        this.all = all;
    }

    @Override
    public void execute() {
        int pos = this.editor.getCaretPosition();
        this.editor.resetHighlighting();
        Vector<Region> occurences = null;
        if (this.all) {
            occurences = GetOccurences.getAll(this.document.get(), this.word, true, Search.CaseSensitive.DEFAULT);
            this.editor.highlightSearchRegions(occurences);
        } else {
            occurences = GetOccurences.getInSelection(this.document.get(), this.word, this.selectionManager.getSelection(), true, Search.CaseSensitive.DEFAULT);
            this.editor.highlightSearchRegions(occurences);
        }
        this.editor.setCaretPosition(pos);
        this.occurences = occurences;
    }

    public Vector<Region> getOccurences() {
        return this.occurences;
    }
}

