/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions;

import com.mbartl.viplugineclipse.viimplementation.command.actions.motion.MotionCommand;
import com.mbartl.viplugineclipse.viimplementation.search.Search;
import com.mbartl.viplugineclipse.viimplementation.search.SearchFactory;
import com.mbartl.viplugineclipse.viimplementation.util.Region;

public class MatchBrace
extends MotionCommand {
    private static final char[] BRACETYPES = new char[]{'{', '}', '[', ']', '(', ')', '<', '>'};
    private Search search = null;
    private String searchString = "";
    private String startString = "";
    private String matchString = "";
    private Search.Direction direction = Search.Direction.FORWARD;
    private final boolean inVisualMode;

    public MatchBrace(boolean inVisualMode) {
        super(1);
        this.search = SearchFactory.getNewRegExpSearch();
        this.inVisualMode = inVisualMode;
    }

    @Override
    public void execute() {
        Region result = null;
        int pos = this.editor.getCaretPosition();
        if (this.inVisualMode) {
            pos = Math.max(0, pos - 1);
        }
        char ch = this.document.getCharAt(pos);
        String text = this.document.get().substring(pos);
        if (this.isPreprocessorStatement(text)) {
            if (text.startsWith("#if")) {
                this.searchString = "#else|#endif";
                this.direction = Search.Direction.FORWARD;
            } else if (text.startsWith("#else")) {
                this.searchString = "#endif";
                this.direction = Search.Direction.FORWARD;
            } else if (text.startsWith("#endif")) {
                this.searchString = "#if";
                this.direction = Search.Direction.BACKWARD;
            }
        } else if (!this.isBrace(ch)) {
            this.searchString = "[<{(\\[]";
            result = this.search.search(this.document.get(), this.searchString, Search.Direction.FORWARD, pos, 0L);
            if (result == null) {
                return;
            }
            pos = result.getOffset();
            ch = this.document.getCharAt(pos);
            this.setSearchParameters(ch);
        } else {
            this.setSearchParameters(ch);
        }
        result = this.searchForMatch(pos);
        if (this.direction == Search.Direction.FORWARD && this.inVisualMode) {
            result = new Region(result.getOffset() + 1, result.getLength() - 1);
        }
        if (result != null) {
            this.editor.setCaretPosition(result.getOffset());
            this.viLayer.getCursorInLinePosition().setCurrentCursorInLinePosition();
        }
    }

    private boolean isPreprocessorStatement(String text) {
        return text.startsWith("#if") || text.startsWith("#else") || text.startsWith("#endif");
    }

    private Region searchForMatch(int pos) {
        int stack = 1;
        boolean found = false;
        int startPos = pos;
        Region result = new Region(startPos, 0);
        long timestamp = System.currentTimeMillis();
        while (!found) {
            result = this.search.search(this.document.get(), this.searchString, this.direction, Search.Mode.NEXT, result.getOffset(), timestamp);
            if (result == null || startPos == result.getOffset()) {
                return null;
            }
            if ("".equals(this.startString) && "".equals(this.matchString)) {
                return result;
            }
            String selection = this.document.getText(result.getOffset(), result.getLength());
            if (selection.equals(this.startString)) {
                ++stack;
                continue;
            }
            if (!selection.equals(this.matchString) || --stack != 0) continue;
            found = true;
        }
        return result;
    }

    private void setSearchParameters(char ch) {
        switch (ch) {
            case '{': {
                this.searchString = "[{}]";
                this.direction = Search.Direction.FORWARD;
                this.matchString = "}";
                this.startString = "{";
                break;
            }
            case '}': {
                this.searchString = "[{}]";
                this.direction = Search.Direction.BACKWARD;
                this.matchString = "{";
                this.startString = "}";
                break;
            }
            case '(': {
                this.searchString = "[\\)\\(]";
                this.direction = Search.Direction.FORWARD;
                this.matchString = ")";
                this.startString = "(";
                break;
            }
            case ')': {
                this.searchString = "[\\)\\(]";
                this.direction = Search.Direction.BACKWARD;
                this.matchString = "(";
                this.startString = ")";
                break;
            }
            case '[': {
                this.searchString = "[\\[\\]]";
                this.direction = Search.Direction.FORWARD;
                this.matchString = "]";
                this.startString = "[";
                break;
            }
            case ']': {
                this.searchString = "[\\[\\]]";
                this.direction = Search.Direction.BACKWARD;
                this.matchString = "[";
                this.startString = "]";
                break;
            }
            case '<': {
                this.searchString = "[<>]";
                this.direction = Search.Direction.FORWARD;
                this.matchString = ">";
                this.startString = "<";
                break;
            }
            case '>': {
                this.searchString = "[<>]";
                this.direction = Search.Direction.BACKWARD;
                this.matchString = "<";
                this.startString = ">";
                break;
            }
            default: {
                this.searchString = "[{}()\\[\\]<>]";
                this.direction = Search.Direction.FORWARD;
            }
        }
    }

    private boolean isBrace(char ch) {
        int i = 0;
        while (i < BRACETYPES.length) {
            if (ch == BRACETYPES[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

