/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.search.Search;
import com.mbartl.viplugineclipse.viimplementation.search.SearchFactory;
import com.mbartl.viplugineclipse.viimplementation.util.Line;

public class PatternDeleteCommand
extends Command {
    private String pattern;
    private boolean isGPattern;
    private Search search = SearchFactory.getNewRegExpSearch();

    public PatternDeleteCommand(String pattern, boolean gpattern) {
        this.pattern = pattern;
        this.isGPattern = gpattern;
    }

    @Override
    public void execute() {
        int i = 0;
        long timestamp = System.currentTimeMillis();
        while (i < this.document.getNumberOfLines()) {
            Line line = this.document.getLine(i);
            String text = this.document.getText(line.getOffset(), line.getLength());
            if (text.length() == 0) {
                ++i;
                continue;
            }
            if (this.isGPattern) {
                if (this.search.search(text, this.pattern, Search.Direction.FORWARD, 0, timestamp) != null) {
                    this.document.replace(line.getOffset(), line.getLength(), "");
                    continue;
                }
                ++i;
                continue;
            }
            if (this.search.search(text, this.pattern, Search.Direction.FORWARD, 0, timestamp) == null) {
                this.document.replace(line.getOffset(), line.getLength(), "");
                continue;
            }
            ++i;
        }
    }
}

