/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.command.actions.YankSelection;
import com.mbartl.viplugineclipse.viimplementation.registers.YankBufferHandler;
import com.mbartl.viplugineclipse.viimplementation.search.Search;
import com.mbartl.viplugineclipse.viimplementation.search.SearchFactory;
import com.mbartl.viplugineclipse.viimplementation.util.Line;

public class PatternYankCommand
extends Command {
    private String pattern;
    private boolean isGPattern;
    private Search search = SearchFactory.getNewRegExpSearch();
    private String register;

    public PatternYankCommand(String pattern, String register, boolean gpattern) {
        this.pattern = pattern;
        this.register = register;
        this.isGPattern = gpattern;
    }

    @Override
    public void execute() {
        if ("_".equals(this.register)) {
            YankBufferHandler.getInstance().getBuffer("_").fill("", "");
        }
        long timestamp = System.currentTimeMillis();
        int i = 0;
        while (i < this.document.getNumberOfLines()) {
            Line line = this.document.getLine(i);
            String text = this.document.getText(line.getOffset(), line.getLength());
            if (this.isGPattern) {
                if (this.search.search(text, this.pattern, Search.Direction.FORWARD, 0, timestamp) != null) {
                    this.selectionManager.setInternalSelection(line.getOffset(), line.getLength());
                    new YankSelection(this.register).execute();
                }
            } else if (this.search.search(text, this.pattern, Search.Direction.FORWARD, 0, timestamp) == null) {
                this.selectionManager.setInternalSelection(line.getOffset(), line.getLength());
                new YankSelection(this.register).execute();
            }
            ++i;
        }
    }
}

