/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions;

import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectLines;
import com.mbartl.viplugineclipse.viimplementation.search.GetOccurences;
import com.mbartl.viplugineclipse.viimplementation.search.Search;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class ReplaceExpressionInSelection
extends Command {
    private String match = null;
    private String replace;
    private boolean global;
    private boolean finished = false;
    private Search.CaseSensitive caseSensitive = Search.CaseSensitive.DEFAULT;
    private boolean confirm = false;
    private final Vector<String> matchBuffers;
    private final Vector<String> replaceBuffers;
    private Vector<Region> occurences;
    private String command;
    private int adjustment = 0;
    private int index = 0;
    private int replacedOccurences = 0;
    private char delimiter = (char)47;

    public ReplaceExpressionInSelection(String cmd, String lastSearch) throws IllegalArgumentException {
        this(cmd, null, lastSearch);
    }

    public ReplaceExpressionInSelection(String cmd, String match, String lastSearch) throws IllegalArgumentException {
        this.command = cmd;
        this.command = this.command.replaceAll("<TAB>", "\t");
        this.command = this.setSelectionAndDelimiter(this.command);
        this.command = this.parseMatchAndReplaceString(this.command);
        if (match != null && (this.match == null || this.match.isEmpty())) {
            this.match = match;
            this.selectionManager.selectAll();
        }
        if (this.match == null || this.replace == null) {
            throw new IllegalArgumentException();
        }
        if (this.match.length() == 0) {
            this.match = lastSearch.substring(0, lastSearch.length() - 1);
        }
        this.match = StringUtils.replace((String)this.match, (String)"\\>", (String)"\\b");
        this.match = StringUtils.replace((String)this.match, (String)"\\<", (String)"\\b");
        this.replace = StringUtils.replace((String)this.replace, (String)"\\/", (String)"/");
        this.replace = StringUtils.replace((String)this.replace, (String)"\\\\", (String)"\\");
        this.replace = StringUtils.replace((String)this.replace, (String)"\\n", (String)"\n");
        this.replace = StringUtils.replace((String)this.replace, (String)"\\r", (String)"\r");
        this.replace = StringUtils.replace((String)this.replace, (String)"\\t", (String)"\t");
        this.parseFlags(this.command);
        this.matchBuffers = this.extractMatchBuffers(this.match);
        this.replaceBuffers = this.extractReplaceBuffers(this.replace);
    }

    @Override
    public void execute() {
        if (this.command == null) {
            return;
        }
        this.viLayer.getUndoManager().beginCompoundChange();
        this.occurences = GetOccurences.getInSelection(this.document.get(), this.match, this.selectionManager.getSelection(), this.global, this.caseSensitive);
        if (this.occurences.size() == 0) {
            ViLayerManager.getInstance().getCurrentLayer().setCommandBufferStatusMessage("Pattern not found: " + this.match);
            this.finished = true;
            return;
        }
        if (!this.confirm) {
            this.replaceOccurences(this.occurences);
            this.viLayer.getUndoManager().endCompoundChange();
            this.finished = true;
            this.viLayer.setCommandBufferStatusMessage("Replaced " + this.occurences.size() + " occurences");
        } else {
            Region selection = this.occurences.get(0);
            this.editor.setCaretPosition(selection.getOffset());
            this.viLayer.setCommandBufferStatusMessage("Replace Occurence: y/n/a/q");
        }
    }

    private String setSelectionAndDelimiter(String command) {
        if (this.selectionManager.getSelection().getLength() == 0) {
            new SelectLines(1, 1, false).execute();
        }
        this.delimiter = command.charAt(1);
        return command.substring(2);
    }

    private void parseFlags(String command) {
        if (command.length() > 0 && command.charAt(0) == this.delimiter) {
            if (StringUtils.contains((String)command, (char)'g')) {
                this.global = true;
            }
            if (StringUtils.contains((String)command, (char)'i')) {
                this.caseSensitive = Search.CaseSensitive.FALSE;
            }
            if (StringUtils.contains((String)command, (char)'I')) {
                this.caseSensitive = Search.CaseSensitive.TRUE;
            }
            if (StringUtils.contains((String)command, (char)'c')) {
                this.confirm = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseMatchAndReplaceString(String command) {
        boolean nextIsEscaped = false;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < command.length()) {
            char ch = command.charAt(i);
            if (ch == '\\') {
                nextIsEscaped = !nextIsEscaped;
                buffer.append(command.charAt(i));
            } else if (ch == this.delimiter) {
                if (!nextIsEscaped) {
                    if (this.match != null) {
                        this.replace = buffer.toString();
                        return command.substring(i);
                    }
                    this.match = buffer.toString();
                    buffer = new StringBuffer("");
                } else {
                    buffer.append(ch);
                }
                nextIsEscaped = false;
            } else if (i == command.length() - 1) {
                buffer.append(ch);
                this.replace = buffer.toString();
            } else {
                nextIsEscaped = false;
                buffer.append(ch);
            }
            ++i;
        }
        return "";
    }

    private Vector<String> extractMatchBuffers(String match) {
        int idx2;
        Vector<String> buffers = new Vector<String>();
        int idx = 0;
        String matchStr = match;
        while ((idx = matchStr.indexOf("\\(", idx)) != -1 && (idx2 = matchStr.indexOf("\\)", idx)) != -1) {
            buffers.add(matchStr.substring(idx + 2, idx2));
            matchStr = String.valueOf(matchStr.substring(0, idx)) + matchStr.substring(idx + 2, idx2) + matchStr.substring(idx2 + 2);
        }
        this.match = matchStr;
        return buffers;
    }

    private Vector<String> extractReplaceBuffers(String replace) {
        Vector<String> buffers = new Vector<String>();
        if (replace.equals("")) {
            return buffers;
        }
        int idx = 0;
        String replaceStr = replace;
        while ((idx = replaceStr.indexOf("\\", idx)) != -1 && replaceStr.length() > idx + 1) {
            try {
                String nr = replaceStr.substring(idx + 1, idx + 2);
                Integer.parseInt(nr);
            }
            catch (NumberFormatException numberFormatException) {
                ++idx;
                continue;
            }
            String entry = replaceStr.substring(0, idx);
            if (entry.length() > 0) {
                buffers.add(entry);
            }
            if ((entry = replaceStr.substring(idx, idx + 2)).length() > 0) {
                buffers.add(entry);
            }
            replaceStr = replaceStr.substring(idx + 2);
        }
        if (replaceStr.length() > 0) {
            buffers.add(replaceStr);
        }
        return buffers;
    }

    private void replaceOccurences(Vector<Region> occurences) {
        int i = 0;
        while (i < occurences.size()) {
            this.replaceOccurence(occurences, i);
            ++i;
        }
    }

    private void replaceOccurence(Vector<Region> occurences, int index) {
        Region selection = occurences.get(index);
        String replace = this.getCurrentReplaceString(selection);
        this.document.replace(selection.getOffset() + this.adjustment, selection.getLength(), replace);
        this.adjustment += replace.length() - selection.getLength();
    }

    private String getCurrentReplaceString(Region selection) {
        String replaceString = "";
        int i = 0;
        while (i < this.replaceBuffers.size()) {
            String buffer = this.replaceBuffers.get(i);
            if (buffer.charAt(0) == '\\' && buffer.length() > 1 && Character.isDigit(buffer.charAt(1))) {
                int nr = Integer.parseInt(buffer.substring(1));
                String match = this.matchBuffers.get(nr - 1);
                Vector<Region> occurence = GetOccurences.getInSelection(this.document.get(), match, selection, this.global, this.caseSensitive);
                Region matchingRegion = occurence.get(0);
                replaceString = String.valueOf(replaceString) + this.document.getText(matchingRegion.getOffset(), matchingRegion.getLength());
            } else {
                replaceString = String.valueOf(replaceString) + buffer;
            }
            ++i;
        }
        return replaceString;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void next(String command) {
        if (command.equalsIgnoreCase("y")) {
            this.replaceOccurence(this.occurences, this.index);
            ++this.replacedOccurences;
        } else {
            if (command.equalsIgnoreCase("a")) {
                while (this.index < this.occurences.size()) {
                    this.replaceOccurence(this.occurences, this.index);
                    ++this.replacedOccurences;
                    ++this.index;
                }
                this.finished = true;
                return;
            }
            if (command.equalsIgnoreCase("q")) {
                this.finished = true;
                return;
            }
        }
        ++this.index;
        if (this.index >= this.occurences.size()) {
            this.finished = true;
        } else {
            Region selection = this.occurences.get(this.index);
            int start = selection.getOffset() + this.adjustment;
            this.editor.setCaretPosition(start);
            this.viLayer.setCommandBufferStatusMessage("Replaced " + this.replacedOccurences + " occurences");
        }
    }
}

