/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions;

import com.mbartl.viplugineclipse.EditorImplementation;
import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.command.actions.HighlightWord;
import com.mbartl.viplugineclipse.viimplementation.search.Search;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import java.util.Vector;

public class SearchDelegate {
    private final int _startPos;
    private final EditorImplementation _editor;
    private final Search _search;
    private Command _postCommand = null;
    private int _searchState;
    private final Search.Direction _direction;
    private final boolean _hlsearch;
    private final boolean _incsearch;
    private String _saveForRepetition;
    public static final int INPROGRESS = 0;
    public static final int INTERRUPTED = 1;
    public static final int FINISHED = 2;

    public SearchDelegate(Search search, Search.Direction direction) {
        this._search = search;
        this._searchState = 0;
        this._direction = direction;
        this._saveForRepetition = "";
        this._hlsearch = PreferenceService.getInstance().getBoolean("hlsearch");
        this._incsearch = PreferenceService.getInstance().getBoolean("incsearch");
        this._editor = ViLayerManager.getInstance().getCurrentLayer().getEditor();
        this._editor.resetHighlighting();
        this._startPos = this._editor.getCaretPosition();
    }

    public SearchDelegate(Search search, Search.Direction direction, Command postCommand, String saveForRepetition) {
        this(search, direction);
        this._postCommand = postCommand;
        this._saveForRepetition = saveForRepetition;
    }

    public void search(String searchCommand) {
        String text = ViLayerManager.getInstance().getCurrentLayer().getDocument().get();
        if (searchCommand.length() >= 1) {
            char lastChar = searchCommand.charAt(searchCommand.length() - 1);
            if (lastChar == '\u001b') {
                this._searchState = 1;
                this._saveForRepetition = "";
            } else if (lastChar == '\n') {
                String word = searchCommand.substring(1, searchCommand.length() - 1);
                this._searchState = 2;
                this._saveForRepetition = String.valueOf(this._saveForRepetition) + searchCommand;
                Region result = this._search.search(text, word, this._direction, this._startPos, 0L);
                if (result != null) {
                    this.setCursor(result.getOffset(), true);
                    if (this._postCommand != null) {
                        this.executePostCommand();
                    } else {
                        Vector<Region> occurences = this.highlightSearchResults(word, true, result.getLength());
                        if (occurences != null) {
                            int i = 0;
                            while (i < occurences.size()) {
                                Region occurence = occurences.get(i);
                                if (occurence.getLength() == result.getLength() && occurence.getOffset() == result.getOffset()) {
                                    ViLayerManager.getInstance().getCurrentLayer().setCommandBufferStatusMessage(String.valueOf(word) + "(" + (i + 1) + "/" + occurences.size() + ")");
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                } else {
                    this.setCursor(this._startPos, true);
                    this._editor.resetHighlighting();
                    ViLayerManager.getInstance().getCurrentLayer().setCommandBufferStatusMessage("Pattern not found: " + word);
                }
            } else {
                Region result = this._search.search(text, searchCommand.substring(1), this._direction, this._startPos, 0L);
                if (result != null) {
                    this.setCursor(result.getOffset(), false);
                    this.highlightSearchResults(searchCommand.substring(1), false, result.getLength());
                } else {
                    this.setCursor(this._startPos, true);
                    this._editor.resetHighlighting();
                }
            }
        }
    }

    public int getSearchState() {
        return this._searchState;
    }

    public String getSaveForRepetition() {
        if (this._postCommand != null) {
            return this._saveForRepetition;
        }
        return null;
    }

    private void executePostCommand() {
        this._postCommand.execute();
    }

    private Vector<Region> highlightSearchResults(String word, boolean all, int resultLength) {
        if (this._hlsearch) {
            if (all) {
                HighlightWord highlightWord = new HighlightWord(word, all);
                highlightWord.execute();
                return highlightWord.getOccurences();
            }
            if (this._incsearch) {
                Vector<Region> ranges = new Vector<Region>();
                ranges.add(new Region(this._editor.getCaretPosition(), resultLength));
                this._editor.resetHighlighting();
                this._editor.highlightSearchRegions(ranges);
            }
        }
        return null;
    }

    private void setCursor(int pos, boolean force) {
        if (this._incsearch || force) {
            this._editor.setCaretPositionAndOpenFoldIfNecessary(pos);
        }
    }
}

