/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions;

import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.registers.TextBuffer;
import com.mbartl.viplugineclipse.viimplementation.registers.YankBufferHandler;
import com.mbartl.viplugineclipse.viimplementation.util.Region;

public class YankSelection
extends Command {
    private final String register;
    private final boolean append;

    public YankSelection(String register) {
        if ("_".equals(register) || Character.isUpperCase(register.charAt(0))) {
            this.append = true;
            this.register = register.toLowerCase();
        } else {
            this.append = false;
            this.register = register;
        }
    }

    @Override
    public void execute() {
        Region selection = this.selectionManager.getSelection();
        String text = this.document.getText(selection.getOffset(), selection.getLength());
        TextBuffer textBuffer = YankBufferHandler.getInstance().getBuffer(this.register);
        if (textBuffer == null) {
            return;
        }
        if (this.append) {
            textBuffer.append(text);
        } else {
            if ("1".equals(this.register)) {
                YankBufferHandler.getInstance().rotateCutBuffers();
            }
            textBuffer.fill(text, this.document.get());
        }
        YankBufferHandler.getInstance().saveRegistersToPreferences();
        this.selectionManager.resetSelection();
        boolean copytoclipboard = PreferenceService.getInstance().getBoolean("copytoclipboard");
        if (this.register.equals("*") || this.register.equals("+") || copytoclipboard && this.register.equals("1")) {
            this.editor.copySelectionToClipboard(selection);
        }
    }
}

