/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.change;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.util.Line;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import com.mbartl.viplugineclipse.viimplementation.util.TextUtils;

public class JoinLine
extends Command {
    private final int counter;

    public JoinLine(int counter) {
        this.counter = counter == 1 ? 2 : counter;
    }

    @Override
    public void execute() {
        String lineText;
        Region selection = this.selectionManager.getSelection();
        int startLinePos = this.document.getLinePosOfOffset(selection.getOffset());
        int endLinePos = selection.getLength() == 0 ? this.document.getLinePosOfOffset(selection.getOffset()) + this.counter - 1 : this.document.getLinePosOfOffset(selection.getOffsetEnd() - 1);
        int startOffset = this.document.getLine(startLinePos).getOffset();
        Line startLine = this.document.getLine(startLinePos);
        String text = lineText = this.document.getText(startLine.getOffset(), startLine.getLengthWithoutDelimiter());
        if (!lineText.endsWith(" ")) {
            text = String.valueOf(text) + " ";
        }
        int i = startLinePos + 1;
        while (i < endLinePos) {
            Line line = this.document.getLine(i);
            lineText = this.document.getText(line.getOffset(), line.getLengthWithoutDelimiter());
            lineText = TextUtils.trimFront(lineText);
            text = String.valueOf(text) + lineText;
            if (!lineText.endsWith(" ")) {
                text = String.valueOf(text) + " ";
            }
            ++i;
        }
        Line endLine = this.document.getLine(endLinePos);
        String endLineText = this.document.getText(endLine.getOffset(), endLine.getLengthWithoutDelimiter());
        text = String.valueOf(text) + TextUtils.trimFront(endLineText);
        int newPos = this.document.getLine(startLinePos).getOffsetEndWithoutDelimiter();
        int endOffset = this.document.getLine(endLinePos).getOffsetEndWithoutDelimiter();
        this.document.replace(startOffset, endOffset - startOffset, text);
        this.editor.setCaretPosition(newPos);
        this.viLayer.getCursorInLinePosition().setCurrentCursorInLinePosition();
    }
}

