/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.change;

import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.util.Line;
import com.mbartl.viplugineclipse.viimplementation.util.TextUtils;

public class NewLineAbove
extends Command {
    private final boolean _useEclipseAction;

    public NewLineAbove(boolean useEclipseAction) {
        this._useEclipseAction = useEclipseAction;
    }

    @Override
    public void execute() {
        boolean successfull;
        if (this._useEclipseAction && (successfull = this.editor.callAction("NEW_LINE_ABOVE"))) {
            if (PreferenceService.getInstance().isSpacesForTabes()) {
                Line line = this.document.getLineOfOffset(this.editor.getCaretPosition());
                String text = this.document.getText(line.getOffset(), line.getLengthWithoutDelimiter());
                int shiftwidth = PreferenceService.getInstance().getInt("shiftwidth");
                text = text.replaceAll("\t", TextUtils.multiplyString(" ", shiftwidth));
                this.document.replace(line.getOffset(), line.getLengthWithoutDelimiter(), text);
            }
            return;
        }
        if (this.document.isEmpty()) {
            this.document.replace(0, 0, "\n");
            this.editor.setCaretPosition(0);
            return;
        }
        Line line = this.document.getLineOfOffset(this.editor.getCaretPosition());
        String delim = line.getDelimiter();
        String whiteSpace = "";
        int smartPos = TextUtils.getFirstVisibleCharacter(this.document.getText(line.getOffset(), line.getLength()), 0);
        if (smartPos != -1) {
            whiteSpace = this.document.getText(line.getOffset(), smartPos);
        }
        int pos = line.getOffset();
        this.document.replace(pos, 0, String.valueOf(whiteSpace) + delim);
        Line newLine = this.document.getLineOfOffset(pos);
        this.editor.setCaretPosition(newLine.getOffsetEndWithoutDelimiter());
    }
}

