/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.change;

import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.util.Line;
import com.mbartl.viplugineclipse.viimplementation.util.TextUtils;

public class NewLineBelow
extends Command {
    private final boolean _useEclipseAction;

    public NewLineBelow(boolean useEclipseAction) {
        this._useEclipseAction = useEclipseAction;
    }

    @Override
    public void execute() {
        boolean successful;
        if (this._useEclipseAction && (successful = this.editor.callAction("NEW_LINE_BELOW"))) {
            if (PreferenceService.getInstance().isSpacesForTabes()) {
                Line line = this.document.getLineOfOffset(this.editor.getCaretPosition());
                String text = this.document.getText(line.getOffset(), line.getLengthWithoutDelimiter());
                int shiftwidth = PreferenceService.getInstance().getInt("shiftwidth");
                text = text.replaceAll("\t", TextUtils.multiplyString(" ", shiftwidth));
                this.document.replace(line.getOffset(), line.getLengthWithoutDelimiter(), text);
            }
            return;
        }
        if (this.document.isEmpty()) {
            this.document.replace(0, 0, String.valueOf(this.document.getStandardDelimiter()) + " ");
            this.editor.setCaretPosition(this.document.get().length() - 1);
            return;
        }
        String whiteSpace = "";
        Line line = this.document.getLineOfOffset(this.editor.getCaretPosition());
        int smartPos = TextUtils.getFirstVisibleCharacter(this.document.getText(line.getOffset(), line.getLength()), 0);
        if (smartPos != -1) {
            whiteSpace = this.document.getText(line.getOffset(), smartPos);
        }
        int pos = line.getOffsetEndWithoutDelimiter();
        String text = String.valueOf(this.document.getStandardDelimiter()) + whiteSpace;
        this.document.replace(pos, 0, text);
        this.editor.setCaretPosition(pos + text.length());
    }
}

