/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.change;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.registers.TextBuffer;
import com.mbartl.viplugineclipse.viimplementation.registers.YankBufferHandler;
import com.mbartl.viplugineclipse.viimplementation.util.Line;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import com.mbartl.viplugineclipse.viimplementation.util.TextUtils;

public class PasteAbove
extends Command {
    private final TextBuffer buffer;
    private final int counter;

    public PasteAbove(int counter, String register) {
        this.counter = counter;
        this.buffer = YankBufferHandler.getInstance().getBuffer(register);
    }

    @Override
    public void execute() {
        if (this.buffer == null) {
            return;
        }
        String text = TextUtils.multiplyString(this.buffer.getText(), this.counter);
        Region selectedText = this.selectionManager.getSelection();
        if (selectedText.getLength() > 0) {
            this.document.replace(selectedText.getOffset(), selectedText.getLength(), text);
            this.editor.setCaretPosition(selectedText.getOffset() + text.length() - 1);
            this.viLayer.switchToCommandMode();
        } else if (!this.buffer.getFullLines()) {
            this.document.replace(this.editor.getCaretPosition(), 0, text);
            this.editor.setCaretPosition(selectedText.getOffset() + text.length() - 1);
        } else {
            if (!TextUtils.endsWithDelimiter(text)) {
                text = String.valueOf(text) + this.document.getStandardDelimiter();
            }
            if (this.document.isEmpty()) {
                this.document.replace(0, 0, String.valueOf(text) + "\n");
                this.editor.setCaretPosition(0);
                return;
            }
            Line line = this.document.getLineOfOffset(this.editor.getCaretPosition());
            String delim = line.getDelimiter();
            if (text.endsWith(delim)) {
                delim = "";
            }
            int pos = line.getOffset();
            text = String.valueOf(delim) + text;
            this.document.replace(pos, 0, text);
            this.editor.setCaretPosition(line.getOffset());
        }
        this.viLayer.getCursorInLinePosition().setCurrentCursorInLinePosition();
    }
}

