/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.change;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.registers.TextBuffer;
import com.mbartl.viplugineclipse.viimplementation.registers.YankBufferHandler;
import com.mbartl.viplugineclipse.viimplementation.util.Line;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import com.mbartl.viplugineclipse.viimplementation.util.TextUtils;

public class PasteBelow
extends Command {
    private final TextBuffer buffer;
    private final int counter;

    public PasteBelow(int counter, String register) {
        this.counter = counter;
        this.buffer = YankBufferHandler.getInstance().getBuffer(register);
    }

    @Override
    public void execute() {
        if (this.buffer == null) {
            return;
        }
        String text = TextUtils.multiplyString(this.buffer.getText(), this.counter);
        if (this.document.isEmpty()) {
            if (!this.buffer.getFullLines()) {
                this.document.replace(this.editor.getCaretPosition(), 0, text);
            } else {
                this.document.replace(0, 0, "\n" + text);
                this.editor.setCaretPosition(0);
            }
            return;
        }
        int pos = this.editor.getCaretPosition();
        Line line = this.document.getLineOfOffset(pos);
        Region selectedText = this.selectionManager.getSelection();
        if (selectedText.getLength() > 0) {
            this.document.replace(selectedText.getOffset(), selectedText.getLength(), text);
            this.editor.setCaretPosition(selectedText.getOffset() + text.length() - 1);
            this.viLayer.switchToCommandMode();
        } else if (!this.buffer.getFullLines()) {
            if (line.getLengthWithoutDelimiter() != 0 && pos != line.getOffsetEndWithoutDelimiter()) {
                ++pos;
            }
            pos = Math.min(pos, this.document.getLength() - 1);
            this.document.replace(pos, 0, text);
            this.editor.setCaretPosition(pos + text.length() - 1);
        } else {
            if (this.document.getLinePosOfOffset(pos) == this.document.getNumberOfLines() - 1) {
                text = String.valueOf(TextUtils.DELIMITER_ON_THIS_PLATFORM) + text;
            }
            this.document.replace(line.getOffsetEnd(), 0, text);
            this.editor.setCaretPosition(line.getOffsetEnd());
        }
        this.viLayer.getCursorInLinePosition().setCurrentCursorInLinePosition();
    }
}

