/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.change;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;

public class ReplayInsertCommand
extends Command {
    private static char DELETE = (char)127;
    private static char BACKSPACE = (char)8;
    public static final int INSERTMODE = 0;
    public static final int REPLACEMODE = 1;
    private final String _insertText;
    private final int _mode;

    public ReplayInsertCommand(String text, int mode) {
        this._insertText = text;
        this._mode = mode;
    }

    @Override
    public void execute() {
        String text = this.cleanupInputText(this._insertText);
        if (this._mode == 0) {
            this.document.replace(this.editor.getCaretPosition(), 0, text);
        } else {
            this.document.replace(this.editor.getCaretPosition(), text.length(), text);
        }
        this.editor.setCaretPosition(this.editor.getCaretPosition() + text.length());
    }

    private String cleanupInputText(String text) {
        StringBuffer cleanedText = new StringBuffer(text.length());
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch == DELETE) {
                ++i;
            } else if (ch == BACKSPACE) {
                if (cleanedText.length() > 0) {
                    cleanedText.deleteCharAt(cleanedText.length() - 1);
                } else if (this.editor.getCaretPosition() - 1 > 0) {
                    this.document.replace(this.editor.getCaretPosition() - 1, 1, "");
                }
            } else {
                cleanedText.append(ch);
            }
            ++i;
        }
        return cleanedText.toString();
    }
}

