/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.change;

import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.command.actions.motion.GotoLine;
import com.mbartl.viplugineclipse.viimplementation.util.Line;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import com.mbartl.viplugineclipse.viimplementation.util.TextUtils;

public class ShiftSelection
extends Command {
    private int counter;
    private final boolean left;

    public ShiftSelection(int counter, boolean left) {
        this.left = left;
        this.counter = counter;
    }

    @Override
    public void execute() {
        int endLinePos;
        int startLinePos;
        Region selection = this.selectionManager.getSelection();
        if (selection.getLength() == 0) {
            startLinePos = this.document.getLinePosOfOffset(this.editor.getCaretPosition());
            endLinePos = Math.min(this.document.getNumberOfLines() - 1, startLinePos + this.counter - 1);
            this.counter = 1;
        } else {
            startLinePos = this.document.getLinePosOfOffset(selection.getOffset());
            endLinePos = this.document.getLinePosOfOffset(selection.getOffsetEnd());
            if (this.document.getLine(endLinePos).getOffset() == selection.getOffsetEnd()) {
                --endLinePos;
            }
        }
        this.viLayer.getUndoManager().beginCompoundChange();
        int shiftWidth = PreferenceService.getInstance().getInt("shiftwidth");
        boolean expandtab = PreferenceService.getInstance().isSpacesForTabes();
        String shiftedText = "";
        int i = startLinePos;
        while (i <= endLinePos) {
            Line line = this.document.getLine(i);
            String lineText = this.document.getText(line.getOffset(), line.getLength());
            shiftedText = String.valueOf(shiftedText) + TextUtils.shiftText(lineText, this.counter, this.left, shiftWidth, expandtab);
            ++i;
        }
        Line startLine = this.document.getLine(startLinePos);
        Line endLine = this.document.getLine(endLinePos);
        this.document.replace(startLine.getOffset(), endLine.getOffsetEnd() - startLine.getOffset(), shiftedText);
        new GotoLine(startLinePos, 2, false).execute();
        this.selectionManager.resetSelection();
        this.viLayer.getUndoManager().endCompoundChange();
    }
}

