/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.delete;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.command.actions.YankSelection;
import com.mbartl.viplugineclipse.viimplementation.command.actions.motion.CheckValidCursorPosition;
import com.mbartl.viplugineclipse.viimplementation.util.Region;

public class DeleteSelection
extends Command {
    private final String _register;
    private final boolean _checkValidCursorPos;

    public DeleteSelection(String register, boolean checkValidCursorPos) {
        this._register = register;
        this._checkValidCursorPos = checkValidCursorPos;
    }

    @Override
    public void execute() {
        Region selection = this.selectionManager.getSelection();
        new YankSelection(this._register).execute();
        boolean deletePreviousDelimiter = this.isRegionAtDocumentEnd(selection);
        int start = Math.max(selection.getOffset(), 0);
        int end = selection.getLength();
        if (deletePreviousDelimiter) {
            int previousLinePos = this.document.getLinePosOfOffset(selection.getOffset()) - 1;
            int delimiterLength = this.document.getLine(previousLinePos).getDelimiter().length();
            start -= delimiterLength;
            end += delimiterLength;
        }
        this.document.replace(start, end, "");
        this.selectionManager.resetSelection();
        this.editor.setCaretPosition(start);
        if (this._checkValidCursorPos) {
            new CheckValidCursorPosition().execute();
        }
    }

    public boolean isRegionAtDocumentEnd(Region selection) {
        int i = 2;
        while (i < this.document.getNumberOfLines()) {
            if (selection.getOffset() == this.document.getLine(i).getOffset() && selection.getOffsetEnd() == this.document.getLength()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

