/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.motion;

import com.mbartl.viplugineclipse.viimplementation.command.actions.motion.MotionCommand;
import com.mbartl.viplugineclipse.viimplementation.util.Line;

public class MoveLeft
extends MotionCommand {
    private final boolean jump;

    public MoveLeft(int counter, boolean jump) {
        super(counter);
        this.jump = jump;
    }

    @Override
    public void execute() {
        if (this.document.isEmpty()) {
            return;
        }
        int cursorPos = this.editor.getCaretPosition();
        if (this.viLayer.isInVisualBlockMode()) {
            cursorPos = this.editor.getBlockSelectionEndPoint();
        }
        int newPos = Math.max(0, cursorPos - this._counter);
        if (!this.viLayer.isInAnyVisualMode()) {
            if (this.jump) {
                int endLinePos = this.document.getLinePosOfOffset(newPos);
                Line endLine = this.document.getLine(endLinePos);
                int delimiterPos = endLine.getOffsetEndWithoutDelimiter();
                int delimiterLength = endLine.getDelimiter().length();
                if (newPos >= delimiterPos && newPos < delimiterPos + delimiterLength) {
                    newPos = endLine.getOffsetEndWithoutDelimiter() - 1;
                    if (endLine.getLengthWithoutDelimiter() == 0) {
                        ++newPos;
                    }
                }
            } else {
                int startLineOffset = this.document.getLineOfOffset(cursorPos).getOffset();
                newPos = Math.max(newPos, startLineOffset);
            }
        }
        this.editor.setCaretPosition(newPos);
        this.viLayer.getCursorInLinePosition().setCurrentCursorInLinePosition();
    }
}

