/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.motion;

import com.mbartl.viplugineclipse.viimplementation.command.actions.motion.MotionCommand;
import com.mbartl.viplugineclipse.viimplementation.util.Line;

public class MoveRight
extends MotionCommand {
    public static final int STOP_AT_LASTCHAR = 0;
    public static final int STOP_AFTER_LASTCHAR = 1;
    public static final int JUMP_TO_NEXT_LINE = 2;
    private final int _mode;

    public MoveRight(int counter, int mode) {
        super(counter);
        this._mode = mode;
    }

    @Override
    public void execute() {
        if (this.document.isEmpty()) {
            return;
        }
        int cursorPos = this.editor.getCaretPosition();
        if (this.viLayer.isInVisualBlockMode()) {
            cursorPos = this.editor.getBlockSelectionEndPoint();
        }
        int newPos = Math.min(cursorPos + this._counter, this.document.getLength() - 1);
        Line startLine = this.document.getLineOfOffset(cursorPos);
        if (!this.viLayer.isInAnyVisualMode()) {
            if (this._mode == 2) {
                int endLinePos = this.document.getLinePosOfOffset(newPos);
                Line endLine = this.document.getLine(endLinePos);
                int delimiterPos = endLine.getOffsetEndWithoutDelimiter();
                int delimiterLength = endLine.getDelimiter().length();
                if (endLinePos != this.document.getNumberOfLines() - 1 && newPos >= delimiterPos && newPos < delimiterPos + delimiterLength) {
                    newPos = this.document.getLine(endLinePos + 1).getOffset();
                }
            } else if (this._mode == 0) {
                int end = startLine.getOffsetEndWithoutDelimiter();
                if (startLine.getLengthWithoutDelimiter() != 0) {
                    --end;
                }
                newPos = Math.min(newPos, end);
            } else {
                int end = startLine.getOffsetEndWithoutDelimiter();
                newPos = Math.min(newPos, end);
            }
        }
        this.editor.setCaretPosition(newPos);
        this.viLayer.getCursorInLinePosition().setCurrentCursorInLinePosition();
    }
}

